/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.annotations.Beta;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.json.document.DocumentParser;
import com.yahoo.document.json.readers.DocumentParseInfo;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.VespaJsonDocumentReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

@Beta
public class JsonReader {
    private final JsonParser parser;
    private final DocumentTypeManager typeManager;
    private ReaderState state = ReaderState.AT_START;

    public Optional<DocumentParseInfo> parseDocument() throws IOException {
        DocumentParser documentParser = new DocumentParser(this.parser);
        return documentParser.parse(Optional.empty());
    }

    public JsonReader(DocumentTypeManager typeManager, InputStream input, JsonFactory parserFactory) {
        this.typeManager = typeManager;
        try {
            this.parser = parserFactory.createParser(input);
        }
        catch (IOException e) {
            this.state = ReaderState.END_OF_FEED;
            throw new RuntimeException(e);
        }
    }

    public DocumentOperation readSingleDocument(DocumentParser.SupportedOperation operationType, String docIdString) {
        DocumentParseInfo documentParseInfo;
        DocumentId docId = new DocumentId(docIdString);
        try {
            DocumentParser documentParser = new DocumentParser(this.parser);
            documentParseInfo = documentParser.parse(Optional.of(docId)).get();
        }
        catch (IOException e) {
            this.state = ReaderState.END_OF_FEED;
            throw new RuntimeException(e);
        }
        documentParseInfo.operationType = operationType;
        VespaJsonDocumentReader vespaJsonDocumentReader = new VespaJsonDocumentReader();
        DocumentOperation operation = vespaJsonDocumentReader.createDocumentOperation(JsonReader.getDocumentTypeFromString(documentParseInfo.documentId.getDocType(), this.typeManager), documentParseInfo);
        operation.setCondition(TestAndSetCondition.fromConditionString(documentParseInfo.condition));
        return operation;
    }

    public DocumentOperation next() {
        Optional<DocumentParseInfo> documentParseInfo;
        switch (this.state) {
            case AT_START: {
                JsonToken t = this.nextToken(this.parser);
                JsonParserHelpers.expectArrayStart(t);
                this.state = ReaderState.READING;
                break;
            }
            case END_OF_FEED: {
                return null;
            }
        }
        try {
            documentParseInfo = this.parseDocument();
        }
        catch (IOException r) {
            this.state = ReaderState.END_OF_FEED;
            throw new RuntimeException(r);
        }
        if (!documentParseInfo.isPresent()) {
            this.state = ReaderState.END_OF_FEED;
            return null;
        }
        VespaJsonDocumentReader vespaJsonDocumentReader = new VespaJsonDocumentReader();
        DocumentOperation operation = vespaJsonDocumentReader.createDocumentOperation(JsonReader.getDocumentTypeFromString(documentParseInfo.get().documentId.getDocType(), this.typeManager), documentParseInfo.get());
        operation.setCondition(TestAndSetCondition.fromConditionString(documentParseInfo.get().condition));
        return operation;
    }

    public DocumentType readDocumentType(DocumentId docId) {
        return JsonReader.getDocumentTypeFromString(docId.getDocType(), this.typeManager);
    }

    private static DocumentType getDocumentTypeFromString(String docTypeString, DocumentTypeManager typeManager) {
        DocumentType docType = typeManager.getDocumentType(docTypeString);
        if (docType == null) {
            throw new IllegalArgumentException(String.format("Document type %s does not exist", docTypeString));
        }
        return docType;
    }

    public JsonToken nextToken(JsonParser parser) {
        try {
            return parser.nextValue();
        }
        catch (IOException e) {
            this.state = ReaderState.END_OF_FEED;
            throw new RuntimeException(e);
        }
    }

    static enum ReaderState {
        AT_START,
        READING,
        END_OF_FEED;

    }
}

