/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.log.LogLevel;
import java.util.logging.Level;

public class SimpleDocumentProcessor
extends DocumentProcessor {
    public void process(DocumentPut put) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Ignored " + put);
        }
    }

    public void process(DocumentUpdate update) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Ignored " + update);
        }
    }

    public void process(DocumentRemove remove) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Ignored " + remove);
        }
    }

    @Override
    public final DocumentProcessor.Progress process(Processing processing) {
        int initialSize = processing.getDocumentOperations().size();
        for (DocumentOperation op : processing.getDocumentOperations()) {
            try {
                if (op instanceof DocumentPut) {
                    this.process((DocumentPut)op);
                    continue;
                }
                if (op instanceof DocumentUpdate) {
                    this.process((DocumentUpdate)op);
                    continue;
                }
                if (!(op instanceof DocumentRemove)) continue;
                this.process((DocumentRemove)op);
            }
            catch (RuntimeException e) {
                if (log.isLoggable((Level)LogLevel.DEBUG) && initialSize != 1) {
                    log.log((Level)LogLevel.DEBUG, "Processing of document failed, from processing.getDocumentOperations() containing " + initialSize + " DocumentOperation(s).", e);
                }
                throw e;
            }
        }
        return DocumentProcessor.Progress.DONE;
    }
}

