/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.restapi.impl;

import com.google.common.annotations.Beta;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.provision.Version;
import com.yahoo.container.jaxrs.annotation.Component;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.http.v2.HttpGetConfigHandler;
import com.yahoo.vespa.config.server.http.v2.HttpListConfigsHandler;
import com.yahoo.vespa.config.server.http.v2.HttpListNamedConfigsHandler;
import com.yahoo.vespa.config.server.http.v2.SessionActiveHandler;
import com.yahoo.vespa.config.server.http.v2.SessionContentHandler;
import com.yahoo.vespa.config.server.http.v2.SessionCreateHandler;
import com.yahoo.vespa.config.server.http.v2.SessionPrepareHandler;
import com.yahoo.vespa.config.server.restapi.resources.StatusInformation;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/")
@Produces(value={"application/json"})
@Beta
public class StatusResource {
    private final ConfigserverConfig configserverConfig;
    private final List<String> modelVersions;

    public StatusResource(@Component SessionCreateHandler create, @Component SessionContentHandler content, @Component SessionPrepareHandler prepare, @Component SessionActiveHandler active, @Component HttpGetConfigHandler getHandler, @Component HttpListConfigsHandler listHandler, @Component HttpListNamedConfigsHandler listNamedHandler, @Component GlobalComponentRegistry componentRegistry) {
        this.configserverConfig = componentRegistry.getConfigserverConfig();
        this.modelVersions = componentRegistry.getModelFactoryRegistry().getFactories().stream().map(ModelFactory::getVersion).map(Version::toString).collect(Collectors.toList());
    }

    @GET
    public StatusInformation getStatus() {
        return new StatusInformation(this.configserverConfig, this.modelVersions);
    }
}

