/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.model;

import com.yahoo.cloud.config.LbServicesConfig;
import com.yahoo.cloud.config.RoutingConfig;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.SuperModel;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.server.model.LbServicesProducer;
import com.yahoo.vespa.config.server.model.RoutingProducer;
import java.util.Collections;
import java.util.Map;

public class SuperModelConfigProvider
implements LbServicesConfig.Producer,
RoutingConfig.Producer {
    private final SuperModel superModel;
    private final LbServicesProducer lbProd;
    private final RoutingProducer zoneProd;

    public SuperModelConfigProvider(SuperModel superModel, Zone zone) {
        this.superModel = superModel;
        this.lbProd = new LbServicesProducer(Collections.unmodifiableMap(superModel.getAllModels()), zone);
        this.zoneProd = new RoutingProducer(Collections.unmodifiableMap(superModel.getAllModels()));
    }

    public SuperModel getSuperModel() {
        return this.superModel;
    }

    public ConfigPayload getConfig(ConfigKey<?> configKey) {
        if (configKey.equals((Object)new ConfigKey(LbServicesConfig.class, configKey.getConfigId()))) {
            LbServicesConfig.Builder builder = new LbServicesConfig.Builder();
            this.getConfig(builder);
            return ConfigPayload.fromInstance((ConfigInstance)new LbServicesConfig(builder));
        }
        if (configKey.equals((Object)new ConfigKey(RoutingConfig.class, configKey.getConfigId()))) {
            RoutingConfig.Builder builder = new RoutingConfig.Builder();
            this.getConfig(builder);
            return ConfigPayload.fromInstance((ConfigInstance)new RoutingConfig(builder));
        }
        throw new ConfigurationRuntimeException(configKey + " is not valid when asking for config from SuperModel");
    }

    public Map<TenantName, Map<ApplicationId, ApplicationInfo>> applicationModels() {
        return this.superModel.getAllModels();
    }

    public void getConfig(LbServicesConfig.Builder builder) {
        this.lbProd.getConfig(builder);
    }

    public void getConfig(RoutingConfig.Builder builder) {
        this.zoneProd.getConfig(builder);
    }

    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ApplicationId applicationId, String configId) {
        TenantName tenant = applicationId.tenant();
        if (!this.superModel.getAllModels().containsKey(tenant)) {
            throw new IllegalArgumentException("Tenant " + tenant + " not found");
        }
        Map applications = (Map)this.superModel.getAllModels().get(tenant);
        if (!applications.containsKey(applicationId)) {
            throw new IllegalArgumentException("Application id " + applicationId + " not found");
        }
        ApplicationInfo application = (ApplicationInfo)applications.get(applicationId);
        ConfigKey key = new ConfigKey(configClass, configId);
        ConfigPayload payload = application.getModel().getConfig(key, null);
        return (CONFIGTYPE)payload.toInstance(configClass, configId);
    }
}

