/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.TenantCreateResponse;
import com.yahoo.vespa.config.server.http.v2.TenantDeleteResponse;
import com.yahoo.vespa.config.server.http.v2.TenantGetResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import com.yahoo.yolean.Exceptions;
import java.util.List;
import java.util.concurrent.Executor;

public class TenantHandler
extends HttpHandler {
    private static final String TENANT_NAME_REGEXP = "[\\w-]+";
    private final Tenants tenants;

    public TenantHandler(Executor executor, AccessLog accessLog, Tenants tenants) {
        super(executor, accessLog);
        this.tenants = tenants;
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        TenantName tenantName = this.getAndValidateTenantFromRequest(request);
        try {
            this.tenants.addTenant(tenantName);
        }
        catch (Exception e) {
            throw new InternalServerException(Exceptions.toMessageString((Throwable)e));
        }
        return new TenantCreateResponse(tenantName);
    }

    private TenantName getAndValidateTenantFromRequest(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromRequest(request);
        this.checkThatTenantDoesNotExist(tenantName);
        this.validateTenantName(tenantName);
        return tenantName;
    }

    private void validateTenantName(TenantName tenant) {
        if (!tenant.value().matches(TENANT_NAME_REGEXP)) {
            throw new BadRequestException("Illegal tenant name: " + tenant);
        }
    }

    @Override
    protected HttpResponse handleGET(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        return new TenantGetResponse(tenantName);
    }

    @Override
    protected HttpResponse handleDELETE(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        Tenant tenant = this.tenants.getTenant(tenantName);
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        List<ApplicationId> activeApplications = applicationRepo.listApplications();
        if (activeApplications.isEmpty()) {
            try {
                this.tenants.deleteTenant(tenantName);
            }
            catch (Exception e) {
                throw new InternalServerException(Exceptions.toMessageString((Throwable)e));
            }
        } else {
            throw new BadRequestException("Cannot delete tenant '" + tenantName + "', as it has active applications: " + activeApplications);
        }
        return new TenantDeleteResponse(tenantName);
    }

    private void checkThatTenantDoesNotExist(TenantName tenantName) {
        if (this.tenants.checkThatTenantExists(tenantName)) {
            throw new BadRequestException("There already exists a tenant '" + tenantName + "'");
        }
    }
}

