/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.application.provider.FileReferenceCreator;
import com.yahoo.net.HostName;
import com.yahoo.vespa.filedistribution.FileDistributionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FileDBRegistry
implements FileRegistry {
    private final FileDistributionManager manager;
    private List<FileRegistry.Entry> entries = new ArrayList<FileRegistry.Entry>();
    private final Map<String, FileReference> fileReferenceCache = new HashMap<String, FileReference>();

    public FileDBRegistry(FileDistributionManager manager) {
        this.manager = manager;
    }

    public synchronized FileReference addFile(String relativePath) {
        Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(relativePath));
        return cachedReference.orElseGet(() -> {
            FileReference newRef = FileReferenceCreator.create((String)this.manager.addFile(relativePath));
            this.entries.add(new FileRegistry.Entry(relativePath, newRef));
            this.fileReferenceCache.put(relativePath, newRef);
            return newRef;
        });
    }

    public String fileSourceHost() {
        return HostName.getLocalhost();
    }

    public synchronized List<FileRegistry.Entry> export() {
        return this.entries;
    }
}

