/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import ai.vespa.validation.StringWrapper;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Endpoint {
    public static final String DEFAULT_ID = "default";
    private static final Pattern endpointPattern = Pattern.compile("^[a-z](?:-?[a-z0-9]+)*$");
    private static final int endpointMaxLength = 12;
    private final String endpointId;
    private final String containerId;
    private final Level level;
    private final List<Target> targets;

    public Endpoint(String endpointId, String containerId, Level level, List<Target> targets) {
        this.endpointId = Objects.requireNonNull(endpointId, "endpointId must be non-null");
        this.containerId = Objects.requireNonNull(containerId, "containerId must be non-null");
        this.level = Objects.requireNonNull(level, "level must be non-null");
        this.targets = List.copyOf((Collection)Objects.requireNonNull(targets, "targets must be non-null"));
        if (this.endpointId().length() > 12 || !endpointPattern.matcher(this.endpointId()).matches()) {
            throw new IllegalArgumentException("Invalid endpoint ID: '" + this.endpointId() + "'");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("targets must be non-empty");
        }
        for (int i = 0; i < targets.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Target a = targets.get(i);
                Target b = targets.get(j);
                if (level == Level.application) {
                    if (a.instance().equals((Object)b.instance())) {
                        throw new IllegalArgumentException("Instance '" + a.instance + "' declared multiple times, but allowed at most once");
                    }
                    if (!a.region().equals((Object)b.region())) {
                        throw new IllegalArgumentException("Instance '" + a.instance + "' declares a region different from instance '" + b.instance() + "': '" + a.region() + "'");
                    }
                }
                if (level != Level.instance || !a.region.equals((Object)b.region)) continue;
                throw new IllegalArgumentException("Region '" + a.region + "' declared multiple times, but allowed at most once");
            }
        }
    }

    public String endpointId() {
        return this.endpointId;
    }

    public String containerId() {
        return this.containerId;
    }

    public List<RegionName> regions() {
        return this.targets.stream().map(Target::region).collect(Collectors.toUnmodifiableList());
    }

    public Level level() {
        return this.level;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public Endpoint withTargets(List<Target> targets) {
        return new Endpoint(this.endpointId, this.containerId, this.level, targets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.endpointId.equals(endpoint.endpointId) && this.containerId.equals(endpoint.containerId) && this.level == endpoint.level && this.targets.equals(endpoint.targets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endpointId, this.containerId, this.level, this.targets});
    }

    public String toString() {
        if (this.level == Level.application) {
            return "endpoint '" + this.endpointId() + "' (cluster " + this.containerId + ") -> " + this.targets.stream().map(Target::toString).sorted().collect(Collectors.joining(", "));
        }
        return "endpoint '" + this.endpointId() + "' (cluster " + this.containerId + ") -> " + this.targets.stream().map(Target::region).map(StringWrapper::value).sorted().collect(Collectors.joining(", "));
    }

    public static enum Level {
        application,
        instance;

    }

    public static class Target {
        private final RegionName region;
        private final InstanceName instance;
        private final int weight;

        public Target(RegionName region, InstanceName instance, int weight) {
            this.region = Objects.requireNonNull(region);
            this.instance = Objects.requireNonNull(instance);
            this.weight = weight;
            if (weight < 0 || weight > 100) {
                throw new IllegalArgumentException("Target must have weight in range [0, 100], got " + weight);
            }
        }

        public RegionName region() {
            return this.region;
        }

        public InstanceName instance() {
            return this.instance;
        }

        public int weight() {
            return this.weight;
        }

        public String toString() {
            return "region=" + this.region + ",instance=" + this.instance + ",weight=" + this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return this.weight == target.weight && this.region.equals((Object)target.region) && this.instance.equals((Object)target.instance);
        }

        public int hashCode() {
            return Objects.hash(this.region, this.instance, this.weight);
        }
    }
}

