/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import java.util.Objects;

public class EndpointCertificateMetadata {
    private final String keyName;
    private final String certName;
    private final int version;
    private final Provider issuer;

    public EndpointCertificateMetadata(String keyName, String certName, int version, Provider issuer) {
        this.keyName = keyName;
        this.certName = certName;
        this.version = version;
        this.issuer = issuer;
    }

    public String keyName() {
        return this.keyName;
    }

    public String certName() {
        return this.certName;
    }

    public int version() {
        return this.version;
    }

    public Provider issuer() {
        return this.issuer;
    }

    public String toString() {
        return "EndpointCertificateMetadata{keyName='" + this.keyName + "', certName='" + this.certName + "', version=" + this.version + ", issuer='" + String.valueOf((Object)this.issuer) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointCertificateMetadata that = (EndpointCertificateMetadata)o;
        return this.version == that.version && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.certName, that.certName) && Objects.equals((Object)this.issuer, (Object)that.issuer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyName, this.certName, this.version, this.issuer});
    }

    public static enum Provider {
        digicert(false),
        globalsign(false),
        zerossl(true),
        letsencrypt(true);

        private final boolean acme;

        private Provider(boolean acme) {
            this.acme = acme;
        }

        public boolean acme() {
            return this.acme;
        }
    }
}

