/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.FileReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public interface FileRegistry {
    public FileReference addFile(String var1);

    public FileReference addUri(String var1);

    public FileReference addBlob(String var1, ByteBuffer var2);

    default public FileReference addApplicationPackage() {
        return this.addFile("");
    }

    public List<Entry> export();

    default public Set<FileReference> asSet() {
        return this.export().stream().map(e -> e.reference).collect(Collectors.toSet());
    }

    public static class Entry {
        public final String relativePath;
        public final FileReference reference;

        public Entry(String relativePath, FileReference reference) {
            this.relativePath = relativePath;
            this.reference = reference;
        }
    }
}

