/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ApplicationClusterEndpoint {
    private final DnsName dnsName;
    private final Scope scope;
    private final RoutingMethod routingMethod;
    private final int weight;
    private final List<String> hostNames;
    private final String clusterId;
    private final AuthMethod authMethod;

    private ApplicationClusterEndpoint(DnsName dnsName, Scope scope, RoutingMethod routingMethod, int weight, List<String> hostNames, String clusterId, AuthMethod authMethod) {
        this.dnsName = Objects.requireNonNull(dnsName);
        this.scope = Objects.requireNonNull(scope);
        this.routingMethod = Objects.requireNonNull(routingMethod);
        this.weight = weight;
        this.hostNames = List.copyOf((Collection)Objects.requireNonNull(hostNames));
        this.clusterId = Objects.requireNonNull(clusterId);
        this.authMethod = Objects.requireNonNull(authMethod);
    }

    public DnsName dnsName() {
        return this.dnsName;
    }

    public Scope scope() {
        return this.scope;
    }

    public RoutingMethod routingMethod() {
        return this.routingMethod;
    }

    public int weight() {
        return this.weight;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public AuthMethod authMethod() {
        return this.authMethod;
    }

    public String toString() {
        return "ApplicationClusterEndpoint{dnsName=" + this.dnsName + ", scope=" + this.scope + ", routingMethod=" + this.routingMethod + ", weight=" + this.weight + ", hostNames=" + this.hostNames + ", clusterId='" + this.clusterId + "', authMethod=" + this.authMethod + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DnsName
    implements Comparable<DnsName> {
        private final String name;

        private DnsName(String name) {
            this.name = name;
        }

        public String value() {
            return this.name;
        }

        public static DnsName from(String name) {
            return new DnsName(name);
        }

        public String toString() {
            return "DnsName{name='" + this.name + "'}";
        }

        @Override
        public int compareTo(DnsName o) {
            return this.name.compareTo(o.name);
        }
    }

    public static enum Scope {
        application,
        global,
        zone;

    }

    public static enum RoutingMethod {
        shared,
        sharedLayer4,
        exclusive;

    }

    public static enum AuthMethod {
        mtls,
        token;

    }

    public static class Builder {
        private DnsName dnsName;
        private Scope scope;
        private RoutingMethod routingMethod;
        private int weight = 1;
        private List<String> hosts;
        private String clusterId;
        private AuthMethod authMethod;

        public Builder dnsName(DnsName name) {
            this.dnsName = name;
            return this;
        }

        public Builder zoneScope() {
            this.scope = Scope.zone;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder sharedRouting() {
            this.routingMethod = RoutingMethod.shared;
            return this;
        }

        public Builder sharedL4Routing() {
            this.routingMethod = RoutingMethod.sharedLayer4;
            return this;
        }

        public Builder routingMethod(RoutingMethod routingMethod) {
            this.routingMethod = routingMethod;
            return this;
        }

        public Builder weight(int weigth) {
            this.weight = weigth;
            return this;
        }

        public Builder hosts(List<String> hosts) {
            this.hosts = List.copyOf(hosts);
            return this;
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder authMethod(AuthMethod authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        public ApplicationClusterEndpoint build() {
            return new ApplicationClusterEndpoint(this.dnsName, this.scope, this.routingMethod, this.weight, this.hosts, this.clusterId, this.authMethod);
        }
    }
}

