/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import java.util.Optional;

public record OnnxModelOptions(Optional<String> executionMode, Optional<Integer> interOpThreads, Optional<Integer> intraOpThreads, Optional<GpuDevice> gpuDevice) {
    public OnnxModelOptions(String executionMode, int interOpThreads, int intraOpThreads, GpuDevice gpuDevice) {
        this(Optional.of(executionMode), Optional.of(interOpThreads), Optional.of(intraOpThreads), Optional.of(gpuDevice));
    }

    public static OnnxModelOptions empty() {
        return new OnnxModelOptions(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public OnnxModelOptions withExecutionMode(String executionMode) {
        return new OnnxModelOptions(Optional.ofNullable(executionMode), this.interOpThreads, this.intraOpThreads, this.gpuDevice);
    }

    public OnnxModelOptions withInterOpThreads(Integer interOpThreads) {
        return new OnnxModelOptions(this.executionMode, Optional.ofNullable(interOpThreads), this.intraOpThreads, this.gpuDevice);
    }

    public OnnxModelOptions withIntraOpThreads(Integer intraOpThreads) {
        return new OnnxModelOptions(this.executionMode, this.interOpThreads, Optional.ofNullable(intraOpThreads), this.gpuDevice);
    }

    public OnnxModelOptions withGpuDevice(GpuDevice gpuDevice) {
        return new OnnxModelOptions(this.executionMode, this.interOpThreads, this.intraOpThreads, Optional.ofNullable(gpuDevice));
    }

    public record GpuDevice(int deviceNumber, boolean required) {
        public GpuDevice {
            if (deviceNumber < 0) {
                throw new IllegalArgumentException("deviceNumber cannot be negative, got " + deviceNumber);
            }
        }

        public GpuDevice(int deviceNumber) {
            this(deviceNumber, false);
        }
    }
}

