/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api.xml;

import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentSpecXmlReader {
    private static final String deploymentTag = "deployment";
    private static final String instanceTag = "instance";
    private static final String testTag = "test";
    private static final String stagingTag = "staging";
    private static final String upgradeTag = "upgrade";
    private static final String blockChangeTag = "block-change";
    private static final String prodTag = "prod";
    private static final String regionTag = "region";
    private static final String delayTag = "delay";
    private static final String parallelTag = "parallel";
    private static final String stepsTag = "steps";
    private static final String endpointsTag = "endpoints";
    private static final String endpointTag = "endpoint";
    private static final String notificationsTag = "notifications";
    private static final String idAttribute = "id";
    private static final String athenzServiceAttribute = "athenz-service";
    private static final String athenzDomainAttribute = "athenz-domain";
    private static final String testerFlavorAttribute = "tester-flavor";
    private static final String majorVersionAttribute = "major-version";
    private final boolean validate;
    private final Clock clock;
    private final List<DeploymentSpec.DeprecatedElement> deprecatedElements = new ArrayList<DeploymentSpec.DeprecatedElement>();

    public DeploymentSpecXmlReader(boolean validate, Clock clock) {
        this.validate = validate;
        this.clock = clock;
    }

    public DeploymentSpecXmlReader() {
        this(true);
    }

    public DeploymentSpecXmlReader(boolean validate) {
        this(validate, Clock.systemUTC());
    }

    public DeploymentSpec read(Reader reader) {
        try {
            return this.read(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public DeploymentSpec read(String xmlForm) {
        this.deprecatedElements.clear();
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        if (!root.getTagName().equals(deploymentTag)) {
            DeploymentSpecXmlReader.illegal("The root tag must be <deployment>");
        }
        if (DeploymentSpecXmlReader.isEmptySpec(root)) {
            return DeploymentSpec.empty;
        }
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        List<Endpoint> applicationEndpoints = List.of();
        if (!this.containsTag(instanceTag, root)) {
            steps.addAll(this.readInstanceContent("default", root, new MutableOptional<String>(), root));
        } else {
            if (XML.getChildren((Element)root).stream().anyMatch(child -> child.getTagName().equals(prodTag))) {
                DeploymentSpecXmlReader.illegal("A deployment spec cannot have both a <prod> tag and an <instance> tag under the root: Wrap the prod tags inside the appropriate instance");
            }
            for (Element child2 : XML.getChildren((Element)root)) {
                String tagName = child2.getTagName();
                if (tagName.equals(instanceTag)) {
                    steps.addAll(this.readInstanceContent(child2.getAttribute(idAttribute), child2, new MutableOptional<String>(), root));
                    continue;
                }
                steps.addAll(this.readNonInstanceSteps(child2, new MutableOptional<String>(), root));
            }
            applicationEndpoints = this.readEndpoints(root, Optional.empty(), steps);
        }
        return new DeploymentSpec(steps, this.optionalIntegerAttribute(majorVersionAttribute, root), DeploymentSpecXmlReader.stringAttribute(athenzDomainAttribute, root).map(AthenzDomain::from), DeploymentSpecXmlReader.stringAttribute(athenzServiceAttribute, root).map(AthenzService::from), applicationEndpoints, xmlForm, this.deprecatedElements);
    }

    private List<DeploymentInstanceSpec> readInstanceContent(String instanceNameString, Element instanceTag, MutableOptional<String> globalServiceId, Element parentTag) {
        if (instanceNameString.isBlank()) {
            DeploymentSpecXmlReader.illegal("<instance> attribute 'id' must be specified, and not be blank");
        }
        if (XML.getChildren((Element)instanceTag).isEmpty() && (instanceTag.getAttributes().getLength() == 0 || instanceTag == parentTag)) {
            return List.of();
        }
        if (this.validate) {
            this.validateTagOrder(instanceTag);
        }
        DeploymentSpec.UpgradePolicy upgradePolicy = this.getWithFallback(instanceTag, parentTag, upgradeTag, "policy", this::readUpgradePolicy, DeploymentSpec.UpgradePolicy.defaultPolicy);
        DeploymentSpec.RevisionTarget revisionTarget = this.getWithFallback(instanceTag, parentTag, upgradeTag, "revision-target", this::readRevisionTarget, DeploymentSpec.RevisionTarget.latest);
        DeploymentSpec.RevisionChange revisionChange = this.getWithFallback(instanceTag, parentTag, upgradeTag, "revision-change", this::readRevisionChange, DeploymentSpec.RevisionChange.whenFailing);
        DeploymentSpec.UpgradeRollout upgradeRollout = this.getWithFallback(instanceTag, parentTag, upgradeTag, "rollout", this::readUpgradeRollout, DeploymentSpec.UpgradeRollout.separate);
        int minRisk = this.getWithFallback(instanceTag, parentTag, upgradeTag, "min-risk", Integer::parseInt, 0);
        int maxRisk = this.getWithFallback(instanceTag, parentTag, upgradeTag, "max-risk", Integer::parseInt, 0);
        int maxIdleHours = this.getWithFallback(instanceTag, parentTag, upgradeTag, "max-idle-hours", Integer::parseInt, 8);
        List<DeploymentSpec.ChangeBlocker> changeBlockers = this.readChangeBlockers(instanceTag, parentTag);
        Optional<AthenzService> athenzService = DeploymentSpecXmlReader.mostSpecificAttribute(instanceTag, athenzServiceAttribute).map(AthenzService::from);
        Notifications notifications = this.readNotifications(instanceTag, parentTag);
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        for (Element instanceChild : XML.getChildren((Element)instanceTag)) {
            steps.addAll(this.readNonInstanceSteps(instanceChild, globalServiceId, instanceChild));
        }
        List<Endpoint> endpoints = this.readEndpoints(instanceTag, Optional.of(instanceNameString), steps);
        Instant now = this.clock.instant();
        return Arrays.stream(instanceNameString.split(",")).map(name -> name.trim()).map(name -> new DeploymentInstanceSpec(InstanceName.from((String)name), steps, upgradePolicy, revisionTarget, revisionChange, upgradeRollout, minRisk, maxRisk, maxIdleHours, changeBlockers, globalServiceId.asOptional(), athenzService, notifications, endpoints, now)).collect(Collectors.toList());
    }

    private List<DeploymentSpec.Step> readSteps(Element stepTag, MutableOptional<String> globalServiceId, Element parentTag) {
        if (stepTag.getTagName().equals(instanceTag)) {
            return new ArrayList<DeploymentSpec.Step>(this.readInstanceContent(stepTag.getAttribute(idAttribute), stepTag, globalServiceId, parentTag));
        }
        return this.readNonInstanceSteps(stepTag, globalServiceId, parentTag);
    }

    private List<DeploymentSpec.Step> readNonInstanceSteps(Element stepTag, MutableOptional<String> globalServiceId, Element parentTag) {
        Optional<AthenzService> athenzService = DeploymentSpecXmlReader.mostSpecificAttribute(stepTag, athenzServiceAttribute).map(AthenzService::from);
        Optional<String> testerFlavor = DeploymentSpecXmlReader.mostSpecificAttribute(stepTag, testerFlavorAttribute);
        if (prodTag.equals(stepTag.getTagName())) {
            globalServiceId.set(this.readGlobalServiceId(stepTag));
        } else if (this.readGlobalServiceId(stepTag).isPresent()) {
            DeploymentSpecXmlReader.illegal("Attribute 'global-service-id' is only valid on 'prod' tag.");
        }
        switch (stepTag.getTagName()) {
            case "test": {
                if (Stream.iterate(stepTag, Objects::nonNull, Node::getParentNode).anyMatch(node -> prodTag.equals(node.getNodeName()))) {
                    return List.of(new DeploymentSpec.DeclaredTest(RegionName.from((String)XML.getValue((Element)stepTag).trim())));
                }
            }
            case "staging": {
                return List.of(new DeploymentSpec.DeclaredZone(Environment.from((String)stepTag.getTagName()), Optional.empty(), false, athenzService, testerFlavor));
            }
            case "prod": {
                return XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readNonInstanceSteps((Element)child, globalServiceId, stepTag).stream()).collect(Collectors.toList());
            }
            case "delay": {
                return List.of(new DeploymentSpec.Delay(Duration.ofSeconds(this.longAttribute("hours", stepTag) * 60L * 60L + this.longAttribute("minutes", stepTag) * 60L + this.longAttribute("seconds", stepTag))));
            }
            case "parallel": {
                return List.of(new DeploymentSpec.ParallelSteps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, globalServiceId, parentTag).stream()).collect(Collectors.toList())));
            }
            case "steps": {
                return List.of(new DeploymentSpec.Steps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, globalServiceId, parentTag).stream()).collect(Collectors.toList())));
            }
            case "region": {
                return List.of(this.readDeclaredZone(Environment.prod, athenzService, testerFlavor, stepTag));
            }
        }
        return List.of();
    }

    private boolean containsTag(String childTagName, Element parent) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!child.getTagName().equals(childTagName) && !this.containsTag(childTagName, child)) continue;
            return true;
        }
        return false;
    }

    private Notifications readNotifications(Element parent, Element fallbackParent) {
        Element notificationsElement = XML.getChild((Element)parent, (String)notificationsTag);
        if (notificationsElement == null) {
            notificationsElement = XML.getChild((Element)fallbackParent, (String)notificationsTag);
        }
        if (notificationsElement == null) {
            return Notifications.none();
        }
        Notifications.When defaultWhen = DeploymentSpecXmlReader.stringAttribute("when", notificationsElement).map(Notifications.When::fromValue).orElse(Notifications.When.failingCommit);
        HashMap<Notifications.When, List<String>> emailAddresses = new HashMap<Notifications.When, List<String>>();
        HashMap<Notifications.When, List<Notifications.Role>> emailRoles = new HashMap<Notifications.When, List<Notifications.Role>>();
        for (Notifications.When when : Notifications.When.values()) {
            emailAddresses.put(when, new ArrayList());
            emailRoles.put(when, new ArrayList());
        }
        for (Element emailElement : XML.getChildren((Element)notificationsElement, (String)"email")) {
            Optional<String> addressAttribute = DeploymentSpecXmlReader.stringAttribute("address", emailElement);
            Optional<Notifications.Role> roleAttribute = DeploymentSpecXmlReader.stringAttribute("role", emailElement).map(Notifications.Role::fromValue);
            Notifications.When when = DeploymentSpecXmlReader.stringAttribute("when", emailElement).map(Notifications.When::fromValue).orElse(defaultWhen);
            if (addressAttribute.isPresent() == roleAttribute.isPresent()) {
                DeploymentSpecXmlReader.illegal("Exactly one of 'role' and 'address' must be present in 'email' elements.");
            }
            addressAttribute.ifPresent(address -> ((List)emailAddresses.get((Object)when)).add(address));
            roleAttribute.ifPresent(role -> ((List)emailRoles.get((Object)when)).add(role));
        }
        return Notifications.of(emailAddresses, emailRoles);
    }

    private List<Endpoint> readEndpoints(Element parent, Optional<String> instance, List<DeploymentSpec.Step> steps) {
        Element endpointsElement = XML.getChild((Element)parent, (String)endpointsTag);
        if (endpointsElement == null) {
            return List.of();
        }
        Endpoint.Level level = instance.isEmpty() ? Endpoint.Level.application : Endpoint.Level.instance;
        LinkedHashMap<String, Endpoint> endpoints = new LinkedHashMap<String, Endpoint>();
        for (Element endpointElement : XML.getChildren((Element)endpointsElement, (String)endpointTag)) {
            Endpoint endpoint;
            String invalidChild;
            String endpointId = DeploymentSpecXmlReader.stringAttribute(idAttribute, endpointElement).orElse("default");
            String containerId = DeploymentSpecXmlReader.requireStringAttribute("container-id", endpointElement);
            String msgPrefix = (level == Endpoint.Level.application ? "Application-level" : "Instance-level") + " endpoint '" + endpointId + "': ";
            String string = invalidChild = level == Endpoint.Level.application ? regionTag : instanceTag;
            if (!XML.getChildren((Element)endpointElement, (String)invalidChild).isEmpty()) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "invalid element '" + invalidChild + "'");
            }
            ArrayList<Endpoint.Target> targets = new ArrayList<Endpoint.Target>();
            if (level == Endpoint.Level.application) {
                String region2 = DeploymentSpecXmlReader.requireStringAttribute(regionTag, endpointElement);
                int weightSum = 0;
                for (Element instanceElement : XML.getChildren((Element)endpointElement, (String)instanceTag)) {
                    int weight;
                    String instanceName = instanceElement.getTextContent();
                    String weightFromAttribute = DeploymentSpecXmlReader.requireStringAttribute("weight", instanceElement);
                    if (instanceName == null || instanceName.isBlank()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "empty 'instance' element");
                    }
                    try {
                        weight = Integer.parseInt(weightFromAttribute);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(msgPrefix + "invalid weight value '" + weightFromAttribute + "'");
                    }
                    weightSum += weight;
                    targets.add(new Endpoint.Target(RegionName.from((String)region2), InstanceName.from((String)instanceName), weight));
                }
                if (weightSum == 0) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "sum of all weights must be positive, got " + weightSum);
                }
            } else {
                if (DeploymentSpecXmlReader.stringAttribute(regionTag, endpointElement).isPresent()) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "invalid 'region' attribute");
                }
                for (Element regionElement : XML.getChildren((Element)endpointElement, (String)regionTag)) {
                    String region3 = regionElement.getTextContent();
                    if (region3 == null || region3.isBlank()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "empty 'region' element");
                    }
                    targets.add(new Endpoint.Target(RegionName.from((String)region3), InstanceName.from((String)instance.get()), 1));
                }
            }
            if (targets.isEmpty() && level == Endpoint.Level.instance) {
                InstanceName instanceName = instance.map(InstanceName::from).get();
                steps.stream().filter(step -> step.concerns(Environment.prod)).flatMap(step -> step.zones().stream()).flatMap(zone -> zone.region().stream()).distinct().map(region -> new Endpoint.Target((RegionName)region, instanceName, 1)).forEach(targets::add);
            }
            if (endpoints.containsKey((endpoint = new Endpoint(endpointId, containerId, level, targets)).endpointId())) {
                DeploymentSpecXmlReader.illegal("Endpoint ID '" + endpoint.endpointId() + "' is specified multiple times");
            }
            endpoints.put(endpoint.endpointId(), endpoint);
        }
        return List.copyOf(endpoints.values());
    }

    private void validateTagOrder(Element root) {
        List<String> tags = XML.getChildren((Element)root).stream().map(Element::getTagName).collect(Collectors.toList());
        for (int i = 0; i < tags.size(); ++i) {
            if (!((String)tags.get(i)).equals(blockChangeTag)) continue;
            String constraint = "<block-change> must be placed after <test> and <staging> and before <prod>";
            if (this.containsAfter(i, testTag, tags)) {
                DeploymentSpecXmlReader.illegal(constraint);
            }
            if (this.containsAfter(i, stagingTag, tags)) {
                DeploymentSpecXmlReader.illegal(constraint);
            }
            if (!this.containsBefore(i, prodTag, tags)) continue;
            DeploymentSpecXmlReader.illegal(constraint);
        }
    }

    private boolean containsAfter(int i, String item, List<String> items) {
        return items.subList(i + 1, items.size()).contains(item);
    }

    private boolean containsBefore(int i, String item, List<String> items) {
        return items.subList(0, i).contains(item);
    }

    private long longAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<Integer> optionalIntegerAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private static Optional<String> stringAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        return Optional.of(value).filter(s -> !s.isBlank());
    }

    private static String requireStringAttribute(String attributeName, Element tag) {
        return DeploymentSpecXmlReader.stringAttribute(attributeName, tag).orElseThrow(() -> new IllegalArgumentException("Missing required attribute '" + attributeName + "' in '" + tag.getTagName() + "'"));
    }

    private DeploymentSpec.DeclaredZone readDeclaredZone(Environment environment, Optional<AthenzService> athenzService, Optional<String> testerFlavor, Element regionTag) {
        return new DeploymentSpec.DeclaredZone(environment, Optional.of(RegionName.from((String)XML.getValue((Element)regionTag).trim())), this.readActive(regionTag), athenzService, testerFlavor);
    }

    private Optional<String> readGlobalServiceId(Element environmentTag) {
        String globalServiceId = environmentTag.getAttribute("global-service-id");
        if (globalServiceId.isEmpty()) {
            return Optional.empty();
        }
        this.deprecate(environmentTag, List.of("global-service-id"), "See https://cloud.vespa.ai/en/reference/routing#deprecated-syntax");
        return Optional.of(globalServiceId);
    }

    private List<DeploymentSpec.ChangeBlocker> readChangeBlockers(Element parent, Element globalBlockersParent) {
        ArrayList<DeploymentSpec.ChangeBlocker> changeBlockers = new ArrayList<DeploymentSpec.ChangeBlocker>();
        if (globalBlockersParent != parent) {
            for (Element tag : XML.getChildren((Element)globalBlockersParent, (String)blockChangeTag)) {
                changeBlockers.add(this.readChangeBlocker(tag));
            }
        }
        for (Element tag : XML.getChildren((Element)parent, (String)blockChangeTag)) {
            changeBlockers.add(this.readChangeBlocker(tag));
        }
        return Collections.unmodifiableList(changeBlockers);
    }

    private DeploymentSpec.ChangeBlocker readChangeBlocker(Element tag) {
        boolean blockVersions = this.trueOrMissing(tag.getAttribute("version"));
        boolean blockRevisions = this.trueOrMissing(tag.getAttribute("revision"));
        String daySpec = tag.getAttribute("days");
        String hourSpec = tag.getAttribute("hours");
        String zoneSpec = tag.getAttribute("time-zone");
        String dateStart = tag.getAttribute("from-date");
        String dateEnd = tag.getAttribute("to-date");
        return new DeploymentSpec.ChangeBlocker(blockRevisions, blockVersions, TimeWindow.from(daySpec, hourSpec, zoneSpec, dateStart, dateEnd));
    }

    private boolean trueOrMissing(String value) {
        return value == null || value.isEmpty() || value.equals("true");
    }

    private <T> T getWithFallback(Element parent, Element fallbackParent, String tagName, String attributeName, Function<String, T> mapper, T fallbackValue) {
        Element element = XML.getChild((Element)parent, (String)tagName);
        if (element == null) {
            element = XML.getChild((Element)fallbackParent, (String)tagName);
        }
        if (element == null) {
            return fallbackValue;
        }
        String attribute = element.getAttribute(attributeName);
        return attribute.isBlank() ? fallbackValue : mapper.apply(attribute);
    }

    private DeploymentSpec.UpgradePolicy readUpgradePolicy(String policy) {
        switch (policy) {
            case "canary": {
                return DeploymentSpec.UpgradePolicy.canary;
            }
            case "default": {
                return DeploymentSpec.UpgradePolicy.defaultPolicy;
            }
            case "conservative": {
                return DeploymentSpec.UpgradePolicy.conservative;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade policy '" + policy + "': Must be one of 'canary', 'default', 'conservative'");
    }

    private DeploymentSpec.RevisionChange readRevisionChange(String revision) {
        switch (revision) {
            case "when-clear": {
                return DeploymentSpec.RevisionChange.whenClear;
            }
            case "when-failing": {
                return DeploymentSpec.RevisionChange.whenFailing;
            }
            case "always": {
                return DeploymentSpec.RevisionChange.always;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade revision change policy '" + revision + "': Must be one of 'always', 'when-failing', 'when-clear'");
    }

    private DeploymentSpec.RevisionTarget readRevisionTarget(String revision) {
        switch (revision) {
            case "next": {
                return DeploymentSpec.RevisionTarget.next;
            }
            case "latest": {
                return DeploymentSpec.RevisionTarget.latest;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade revision target '" + revision + "': Must be one of 'next', 'latest'");
    }

    private DeploymentSpec.UpgradeRollout readUpgradeRollout(String rollout) {
        switch (rollout) {
            case "separate": {
                return DeploymentSpec.UpgradeRollout.separate;
            }
            case "leading": {
                return DeploymentSpec.UpgradeRollout.leading;
            }
            case "simultaneous": {
                return DeploymentSpec.UpgradeRollout.simultaneous;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade rollout '" + rollout + "': Must be one of 'separate', 'leading', 'simultaneous'");
    }

    private boolean readActive(Element regionTag) {
        String activeValue = regionTag.getAttribute("active");
        if ("".equals(activeValue)) {
            return true;
        }
        this.deprecate(regionTag, List.of("active"), "See https://cloud.vespa.ai/en/reference/routing#deprecated-syntax");
        if ("true".equals(activeValue)) {
            return true;
        }
        if ("false".equals(activeValue)) {
            return false;
        }
        throw new IllegalArgumentException("Value of 'active' attribute in region tag must be 'true' or 'false' to control whether this region should receive traffic from the global endpoint of this application");
    }

    private void deprecate(Element element, List<String> attributes, String message) {
        this.deprecatedElements.add(new DeploymentSpec.DeprecatedElement(element.getTagName(), attributes, message));
    }

    private static boolean isEmptySpec(Element root) {
        if (!XML.getChildren((Element)root).isEmpty()) {
            return false;
        }
        return root.getAttributes().getLength() == 0 || root.getAttributes().getLength() == 1 && root.hasAttribute("version");
    }

    private static Optional<String> mostSpecificAttribute(Element tag, String attributeName) {
        return Stream.iterate(tag, Objects::nonNull, Node::getParentNode).filter(Element.class::isInstance).map(Element.class::cast).flatMap(element -> DeploymentSpecXmlReader.stringAttribute(attributeName, element).stream()).findFirst();
    }

    private static void illegal(String message) {
        throw new IllegalArgumentException(message);
    }

    private static class MutableOptional<T> {
        private Optional<T> value = Optional.empty();

        private MutableOptional() {
        }

        public void set(Optional<T> value) {
            this.value = value;
        }

        public Optional<T> asOptional() {
            return this.value;
        }
    }
}

