/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public interface ModelContext {
    public ApplicationPackage applicationPackage();

    public Optional<Model> previousModel();

    public Optional<ApplicationPackage> permanentApplicationPackage();

    public HostProvisioner getHostProvisioner();

    public Provisioned provisioned();

    public DeployLogger deployLogger();

    public ConfigDefinitionRepo configDefinitionRepo();

    public FileRegistry getFileRegistry();

    public ExecutorService getExecutor();

    default public Optional<? extends Reindexing> reindexing() {
        return Optional.empty();
    }

    public Properties properties();

    default public Optional<File> appDir() {
        return Optional.empty();
    }

    default public Optional<DockerImage> wantedDockerImageRepo() {
        return Optional.empty();
    }

    public Version modelVespaVersion();

    public Version wantedNodeVespaVersion();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ModelFeatureFlag {
        public String[] owners();

        public String removeAfter() default "";

        public String comment() default "";
    }

    public static interface Properties {
        public FeatureFlags featureFlags();

        public boolean multitenant();

        public ApplicationId applicationId();

        public List<ConfigServerSpec> configServerSpecs();

        public HostName loadBalancerName();

        public URI ztsUrl();

        public String athenzDnsSuffix();

        public boolean hostedVespa();

        public Zone zone();

        public Set<ContainerEndpoint> endpoints();

        public boolean isBootstrap();

        public boolean isFirstTimeDeployment();

        default public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return Optional.empty();
        }

        default public Optional<AthenzDomain> athenzDomain() {
            return Optional.empty();
        }

        default public Optional<ApplicationRoles> applicationRoles() {
            return Optional.empty();
        }

        default public Quota quota() {
            return Quota.unlimited();
        }

        default public List<TenantSecretStore> tenantSecretStores() {
            return List.of();
        }

        default public String jvmGCOptions() {
            return this.jvmGCOptions(Optional.empty());
        }

        public String jvmGCOptions(Optional<ClusterSpec.Type> var1);

        default public boolean useDedicatedNodeForLogserver() {
            return true;
        }

        default public boolean allowDisableMtls() {
            return true;
        }

        default public List<X509Certificate> operatorCertificates() {
            return List.of();
        }

        default public List<String> tlsCiphersOverride() {
            return List.of();
        }

        default public List<String> zoneDnsSuffixes() {
            return List.of();
        }

        public List<String> environmentVariables();
    }

    public static interface FeatureFlags {
        @ModelFeatureFlag(owners={"baldersheim"}, comment="Revisit in May or June 2021")
        default public double defaultTermwiseLimit() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public boolean useThreePhaseUpdates() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"}, comment="Select sequencer type use while feeding")
        default public String feedSequencerType() {
            return "THROUGHPUT";
        }

        @ModelFeatureFlag(owners={"geirst, baldersheim"})
        default public int feedTaskLimit() {
            return 1000;
        }

        @ModelFeatureFlag(owners={"geirst, baldersheim"})
        default public int feedMasterTaskLimit() {
            return 1000;
        }

        @ModelFeatureFlag(owners={"geirst, baldersheim"})
        default public String sharedFieldWriterExecutor() {
            return "NONE";
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public String responseSequencerType() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int defaultNumResponseThreads() {
            return 2;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean skipCommunicationManagerThread() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean skipMbusRequestThread() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean skipMbusReplyThread() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean useAsyncMessageHandlingOnSchedule() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public double feedConcurrency() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int defaultPoolNumThreads() {
            return 2;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int availableProcessors() {
            return 2;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int maxUnCommittedMemory() {
            return 130000;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int maxConcurrentMergesPerNode() {
            return 16;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int maxMergeQueueSize() {
            return 100;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean containerDumpHeapOnShutdownTimeout() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public double containerShutdownTimeout() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"geirst"}, removeAfter="7.541")
        default public boolean enableFeedBlockInDistributor() {
            return true;
        }

        @ModelFeatureFlag(owners={"bjorncs", "tokle"})
        default public List<String> allowedAthenzProxyIdentities() {
            return List.of();
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int maxActivationInhibitedOutOfSyncGroups() {
            return 0;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
            return "";
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double resourceLimitDisk() {
            return 0.75;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double resourceLimitMemory() {
            return 0.8;
        }

        @ModelFeatureFlag(owners={"geirst", "vekterli"})
        default public double minNodeRatioPerGroup() {
            return 0.0;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean forwardIssuesAsErrors() {
            return true;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean ignoreThreadStackSizes() {
            return false;
        }

        @ModelFeatureFlag(owners={"vekterli", "geirst"})
        default public boolean unorderedMergeChaining() {
            return true;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean useV8GeoPositions() {
            return false;
        }

        @ModelFeatureFlag(owners={"arnej", "baldersheim"})
        default public boolean useV8DocManagerCfg() {
            return false;
        }

        @ModelFeatureFlag(owners={"baldersheim", "geirst", "toregge"})
        default public int maxCompactBuffers() {
            return 1;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public boolean failDeploymentWithInvalidJvmOptions() {
            return false;
        }

        @ModelFeatureFlag(owners={"arnej", "andreer"})
        default public List<String> ignoredHttpUserAgents() {
            return List.of();
        }

        @ModelFeatureFlag(owners={"bjorncs"})
        default public boolean enableServerOcspStapling() {
            return false;
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public String persistenceAsyncThrottling() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public String mergeThrottlingPolicy() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public double persistenceThrottlingWsDecrementFactor() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public double persistenceThrottlingWsBackoff() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int persistenceThrottlingWindowSize() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public double persistenceThrottlingWsResizeRate() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public boolean persistenceThrottlingOfMergeFeedOps() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"geirst", "vekterli"})
        default public boolean inhibitDefaultMergesWhenGlobalMergesPending() {
            return false;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean useQrserverServiceName() {
            return true;
        }

        @ModelFeatureFlag(owners={"bjorncs", "baldersheim"})
        default public boolean enableJdiscPreshutdownCommand() {
            return true;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean avoidRenamingSummaryFeatures() {
            return false;
        }

        @ModelFeatureFlag(owners={"bjorncs", "baldersheim"})
        default public boolean mergeGroupingResultInSearchInvoker() {
            return false;
        }
    }
}

