/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeploymentInstanceSpec
extends DeploymentSpec.Steps {
    private static final int maxUpgradeBlockingDays = 21;
    private final InstanceName name;
    private final DeploymentSpec.UpgradePolicy upgradePolicy;
    private final DeploymentSpec.RevisionTarget revisionTarget;
    private final DeploymentSpec.RevisionChange revisionChange;
    private final DeploymentSpec.UpgradeRollout upgradeRollout;
    private final List<DeploymentSpec.ChangeBlocker> changeBlockers;
    private final Optional<String> globalServiceId;
    private final Optional<AthenzService> athenzService;
    private final Notifications notifications;
    private final List<Endpoint> endpoints;

    public DeploymentInstanceSpec(InstanceName name, List<DeploymentSpec.Step> steps, DeploymentSpec.UpgradePolicy upgradePolicy, DeploymentSpec.RevisionTarget revisionTarget, DeploymentSpec.RevisionChange revisionChange, DeploymentSpec.UpgradeRollout upgradeRollout, List<DeploymentSpec.ChangeBlocker> changeBlockers, Optional<String> globalServiceId, Optional<AthenzService> athenzService, Notifications notifications, List<Endpoint> endpoints, Instant now) {
        super(steps);
        this.name = name;
        this.upgradePolicy = upgradePolicy;
        this.revisionTarget = revisionTarget;
        this.revisionChange = revisionChange;
        this.upgradeRollout = upgradeRollout;
        this.changeBlockers = changeBlockers;
        this.globalServiceId = globalServiceId;
        this.athenzService = athenzService;
        this.notifications = notifications;
        this.endpoints = List.copyOf(endpoints);
        DeploymentInstanceSpec.validateZones(new HashSet<RegionName>(), new HashSet<RegionName>(), this);
        this.validateEndpoints(this.steps(), globalServiceId, this.endpoints);
        this.validateChangeBlockers(changeBlockers, now);
    }

    public InstanceName name() {
        return this.name;
    }

    private static void validateZones(Set<RegionName> deployments, Set<RegionName> tests, DeploymentSpec.Step step) {
        if (!step.steps().isEmpty()) {
            Set<RegionName> oldDeployments = Set.copyOf(deployments);
            for (DeploymentSpec.Step nested : step.steps()) {
                HashSet<RegionName> seenDeployments = new HashSet<RegionName>(step.isOrdered() ? deployments : oldDeployments);
                DeploymentInstanceSpec.validateZones(seenDeployments, tests, nested);
                deployments.addAll(seenDeployments);
            }
        } else if (step.concerns(Environment.prod)) {
            if (step.isTest()) {
                RegionName region = ((DeploymentSpec.DeclaredTest)step).region();
                if (!deployments.contains(region)) {
                    throw new IllegalArgumentException("tests for prod." + region + " must be after the corresponding deployment in deployment.xml");
                }
                if (!tests.add(region)) {
                    throw new IllegalArgumentException("tests for prod." + region + " are listed twice in deployment.xml");
                }
            } else {
                RegionName region = ((DeploymentSpec.DeclaredZone)step).region().get();
                if (!deployments.add(region)) {
                    throw new IllegalArgumentException("prod." + region + " is listed twice in deployment.xml");
                }
            }
        }
    }

    private void validateEndpoints(List<DeploymentSpec.Step> steps, Optional<String> globalServiceId, List<Endpoint> endpoints) {
        if (globalServiceId.isPresent() && !endpoints.isEmpty()) {
            throw new IllegalArgumentException("Providing both 'endpoints' and 'global-service-id'. Use only 'endpoints'.");
        }
        Set stepZones = steps.stream().flatMap(s -> s.zones().stream()).flatMap(z -> z.region().stream()).collect(Collectors.toSet());
        for (Endpoint endpoint : endpoints) {
            for (RegionName endpointRegion : endpoint.regions()) {
                if (stepZones.contains(endpointRegion)) continue;
                throw new IllegalArgumentException("Region used in endpoint that is not declared in 'prod': " + endpointRegion);
            }
        }
    }

    private void validateChangeBlockers(List<DeploymentSpec.ChangeBlocker> changeBlockers, Instant now) {
        Stream<Instant> blockingFrom = changeBlockers.stream().filter(blocker -> blocker.blocksVersions()).map(blocker -> blocker.window()).map(window -> window.dateRange().start().map(date -> date.atStartOfDay(window.zone()).toInstant()).orElse(now)).distinct();
        if (!blockingFrom.allMatch(this::canUpgradeWithinDeadline)) {
            throw new IllegalArgumentException("Cannot block Vespa upgrades for longer than 21 consecutive days");
        }
    }

    private boolean canUpgradeWithinDeadline(Instant instant) {
        instant = instant.truncatedTo(ChronoUnit.HOURS);
        Duration step = Duration.ofHours(1L);
        Duration max = Duration.ofDays(21L);
        Instant current = instant;
        while (!this.canUpgradeAt(current)) {
            Duration blocked = Duration.between(instant, current);
            if (blocked.compareTo(max) > 0) {
                return false;
            }
            current = current.plus(step);
        }
        return true;
    }

    public DeploymentSpec.UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public DeploymentSpec.RevisionTarget revisionTarget() {
        return this.revisionTarget;
    }

    public DeploymentSpec.RevisionChange revisionChange() {
        return this.revisionChange;
    }

    public DeploymentSpec.UpgradeRollout upgradeRollout() {
        return this.upgradeRollout;
    }

    public List<DeploymentSpec.ChangeBlocker> changeBlocker() {
        return this.changeBlockers;
    }

    public Optional<String> globalServiceId() {
        return this.globalServiceId;
    }

    public boolean canUpgradeAt(Instant instant) {
        return this.changeBlockers.stream().filter(block -> block.blocksVersions()).noneMatch(block -> block.window().includes(instant));
    }

    public boolean canChangeRevisionAt(Instant instant) {
        return this.changeBlockers.stream().filter(block -> block.blocksRevisions()).noneMatch(block -> block.window().includes(instant));
    }

    public Optional<AthenzService> athenzService(Environment environment, RegionName region) {
        return this.zones().stream().filter(zone -> zone.concerns(environment, Optional.of(region))).findFirst().flatMap(DeploymentSpec.DeclaredZone::athenzService).or(() -> this.athenzService);
    }

    public Notifications notifications() {
        return this.notifications;
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public boolean deploysTo(Environment environment, RegionName region) {
        return this.zones().stream().anyMatch(zone -> zone.concerns(environment, Optional.of(region)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentInstanceSpec other = (DeploymentInstanceSpec)o;
        return this.globalServiceId.equals(other.globalServiceId) && this.upgradePolicy == other.upgradePolicy && this.revisionTarget == other.revisionTarget && this.upgradeRollout == other.upgradeRollout && this.changeBlockers.equals(other.changeBlockers) && this.steps().equals(other.steps()) && this.athenzService.equals(other.athenzService) && this.notifications.equals(other.notifications) && this.endpoints.equals(other.endpoints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.globalServiceId, this.upgradePolicy, this.revisionTarget, this.upgradeRollout, this.changeBlockers, this.steps(), this.athenzService, this.notifications, this.endpoints});
    }

    int deployableHashCode() {
        List zones = this.zones().stream().filter(zone -> zone.concerns(Environment.prod)).collect(Collectors.toList());
        Object[] toHash = new Object[zones.size() + 3];
        int i = 0;
        toHash[i++] = this.name;
        toHash[i++] = this.endpoints;
        toHash[i++] = this.globalServiceId;
        for (DeploymentSpec.DeclaredZone zone2 : zones) {
            toHash[i++] = Objects.hash(zone2, zone2.athenzService());
        }
        return Arrays.hashCode(toHash);
    }

    @Override
    public String toString() {
        return "instance '" + this.name + "'";
    }
}

