/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.FileReference;
import com.yahoo.net.HostName;
import java.nio.ByteBuffer;
import java.util.List;
import net.jpountz.xxhash.XXHashFactory;

public interface FileRegistry {
    public FileReference addFile(String var1);

    public FileReference addUri(String var1);

    public FileReference addBlob(ByteBuffer var1);

    default public FileReference addApplicationPackage() {
        return this.addFile("");
    }

    @Deprecated
    default public String fileSourceHost() {
        return HostName.getLocalhost();
    }

    public List<Entry> export();

    public static String blobName(ByteBuffer blob) {
        blob.mark();
        long blobHash = XXHashFactory.fastestJavaInstance().hash64().hash(blob, 0L);
        blob.reset();
        return Long.toHexString(blobHash);
    }

    public static class Entry {
        public final String relativePath;
        public final FileReference reference;

        public Entry(String relativePath, FileReference reference) {
            this.relativePath = relativePath;
            this.reference = reference;
        }
    }
}

