/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TimeWindow {
    private final List<DayOfWeek> days;
    private final List<Integer> hours;
    private final ZoneId zone;

    private TimeWindow(List<DayOfWeek> days, List<Integer> hours, ZoneId zone) {
        this.days = Collections.unmodifiableList(new ArrayList<DayOfWeek>(new TreeSet<DayOfWeek>(days)));
        this.hours = Collections.unmodifiableList(new ArrayList<Integer>(new TreeSet<Integer>(hours)));
        this.zone = zone;
    }

    public List<DayOfWeek> days() {
        return this.days;
    }

    public List<Integer> hours() {
        return this.hours;
    }

    public ZoneId zone() {
        return this.zone;
    }

    public boolean includes(Instant instant) {
        LocalDateTime dt = LocalDateTime.ofInstant(instant, this.zone);
        return this.days.contains(dt.getDayOfWeek()) && this.hours.contains(dt.getHour());
    }

    public String toString() {
        return "time window for hour(s) " + this.hours.toString() + " on " + this.days.stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()).toString() + " in " + this.zone;
    }

    public static TimeWindow from(String daySpec, String hourSpec, String zoneSpec) {
        List<DayOfWeek> days = TimeWindow.parse(daySpec, TimeWindow::parseDays);
        List<Integer> hours = TimeWindow.parse(hourSpec, TimeWindow::parseHours);
        ZoneId zone = TimeWindow.zoneFrom(zoneSpec);
        return new TimeWindow(days, hours, zone);
    }

    private static <T> List<T> parse(String spec, BiFunction<String, String, List<T>> valueParser) {
        String[] parts;
        ArrayList values = new ArrayList();
        for (String part : parts = spec.split(",")) {
            if (part.contains("-")) {
                String[] startAndEnd = part.split("-");
                if (startAndEnd.length != 2) {
                    throw new IllegalArgumentException("Invalid range '" + part + "'");
                }
                values.addAll(valueParser.apply(startAndEnd[0], startAndEnd[1]));
                continue;
            }
            values.addAll(valueParser.apply(part, part));
        }
        return Collections.unmodifiableList(values);
    }

    private static List<Integer> parseHours(String startInclusive, String endInclusive) {
        int start = TimeWindow.hourFrom(startInclusive);
        int end = TimeWindow.hourFrom(endInclusive);
        if (end < start) {
            throw new IllegalArgumentException(String.format("Invalid hour range '%s-%s'", startInclusive, endInclusive));
        }
        return IntStream.rangeClosed(start, end).boxed().collect(Collectors.toList());
    }

    private static List<DayOfWeek> parseDays(String startInclusive, String endInclusive) {
        DayOfWeek start = TimeWindow.dayFrom(startInclusive);
        DayOfWeek end = TimeWindow.dayFrom(endInclusive);
        if (end.getValue() < start.getValue()) {
            throw new IllegalArgumentException(String.format("Invalid day range '%s-%s'", startInclusive, endInclusive));
        }
        return IntStream.rangeClosed(start.getValue(), end.getValue()).boxed().map(DayOfWeek::of).collect(Collectors.toList());
    }

    private static DayOfWeek dayFrom(String day) {
        return Arrays.stream(DayOfWeek.values()).filter(dayOfWeek -> day.length() >= 3 && dayOfWeek.name().toLowerCase().startsWith(day)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid day '" + day + "'"));
    }

    private static int hourFrom(String hour) {
        try {
            return ChronoField.HOUR_OF_DAY.checkValidIntValue(Integer.parseInt(hour));
        }
        catch (NumberFormatException | DateTimeException e) {
            throw new IllegalArgumentException("Invalid hour '" + hour + "'", e);
        }
    }

    private static ZoneId zoneFrom(String zone) {
        try {
            return ZoneId.of(zone);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("Invalid time zone '" + zone + "'", e);
        }
    }
}

