/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.util.Objects;
import java.util.Optional;

public class Quota {
    private final Optional<Integer> maxClusterSize;
    private final Optional<Integer> budget;

    public Quota(Optional<Integer> maybeClusterSize, Optional<Integer> budget) {
        this.maxClusterSize = maybeClusterSize;
        this.budget = budget;
    }

    public static Quota fromSlime(Inspector inspector) {
        Optional clusterSize = SlimeUtils.optionalLong((Inspector)inspector.field("clusterSize"));
        Optional budget = SlimeUtils.optionalLong((Inspector)inspector.field("budget"));
        return new Quota(clusterSize.map(Long::intValue), budget.map(Long::intValue));
    }

    public Slime toSlime() {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        this.maxClusterSize.ifPresent(clusterSize -> root.setLong("clusterSize", (long)clusterSize.intValue()));
        this.budget.ifPresent(b -> root.setLong("budget", (long)b.intValue()));
        return slime;
    }

    public static Quota empty() {
        return new Quota(Optional.empty(), Optional.empty());
    }

    public Optional<Integer> maxClusterSize() {
        return this.maxClusterSize;
    }

    public Optional<Integer> budget() {
        return this.budget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quota quota = (Quota)o;
        return Objects.equals(this.maxClusterSize, quota.maxClusterSize) && Objects.equals(this.budget, quota.budget);
    }

    public int hashCode() {
        return Objects.hash(this.maxClusterSize, this.budget);
    }

    public String toString() {
        return "Quota{maxClusterSize=" + this.maxClusterSize + ", budget=" + this.budget + "}";
    }
}

