/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.collections.Comparables;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.application.api.xml.DeploymentSpecXmlReader;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import java.io.Reader;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeploymentSpec {
    public static final DeploymentSpec empty = new DeploymentSpec(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), "<deployment version='1.0'/>");
    private final List<Step> steps;
    private final Optional<Integer> majorVersion;
    private final Optional<AthenzDomain> athenzDomain;
    private final Optional<AthenzService> athenzService;
    private final String xmlForm;

    public DeploymentSpec(List<Step> steps, Optional<Integer> majorVersion, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, String xmlForm) {
        this.steps = List.copyOf(steps);
        this.majorVersion = majorVersion;
        this.athenzDomain = athenzDomain;
        this.athenzService = athenzService;
        this.xmlForm = xmlForm;
        this.validateTotalDelay(steps);
        this.validateUpgradePoliciesOfIncreasingConservativeness(steps);
        this.validateAthenz();
    }

    private void validateTotalDelay(List<Step> steps) {
        long totalDelaySeconds = steps.stream().mapToLong(step -> step.delay().getSeconds()).sum();
        if (totalDelaySeconds > Duration.ofHours(24L).getSeconds()) {
            throw new IllegalArgumentException("The total delay specified is " + Duration.ofSeconds(totalDelaySeconds) + " but max 24 hours is allowed");
        }
    }

    private void validateUpgradePoliciesOfIncreasingConservativeness(List<Step> steps) {
        UpgradePolicy previous = Collections.min(List.of(UpgradePolicy.values()));
        for (Step step : steps) {
            UpgradePolicy strictest = previous;
            List<DeploymentInstanceSpec> specs = DeploymentSpec.instances(List.of(step));
            for (DeploymentInstanceSpec spec : specs) {
                if (spec.upgradePolicy().compareTo(previous) < 0) {
                    throw new IllegalArgumentException("Instance '" + spec.name() + "' cannot have a looser upgrade policy than the previous of '" + previous + "'");
                }
                strictest = (UpgradePolicy)((Object)Comparables.max((Comparable)((Object)strictest), (Comparable)((Object)spec.upgradePolicy())));
            }
            previous = strictest;
        }
    }

    private void validateAthenz() {
        block5: {
            block4: {
                if (!this.athenzDomain.isEmpty()) break block4;
                for (DeploymentInstanceSpec instance : this.instances()) {
                    for (DeclaredZone zone : instance.zones()) {
                        if (!zone.athenzService().isPresent()) continue;
                        throw new IllegalArgumentException("Athenz service configured for zone: " + zone + ", but Athenz domain is not configured");
                    }
                }
                break block5;
            }
            if (!this.athenzService.isEmpty()) break block5;
            for (DeploymentInstanceSpec instance : this.instances()) {
                for (DeclaredZone zone : instance.zones()) {
                    if (!zone.athenzService().isEmpty()) continue;
                    throw new IllegalArgumentException("Athenz domain is configured, but Athenz service not configured for zone: " + zone);
                }
            }
        }
    }

    public Optional<Integer> majorVersion() {
        return this.majorVersion;
    }

    public List<Step> steps() {
        return this.steps;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return this.athenzDomain;
    }

    public Optional<AthenzService> athenzService() {
        return this.athenzService;
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public Optional<DeploymentInstanceSpec> instance(InstanceName name) {
        for (DeploymentInstanceSpec instance : this.instances()) {
            if (!instance.name().equals((Object)name)) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public DeploymentInstanceSpec requireInstance(String name) {
        return this.requireInstance(InstanceName.from((String)name));
    }

    public DeploymentInstanceSpec requireInstance(InstanceName name) {
        Optional<DeploymentInstanceSpec> instance = this.instance(name);
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("No instance '" + name + "' in deployment.xml'. Instances: " + this.instances().stream().map(spec -> spec.name().toString()).collect(Collectors.joining(",")));
        }
        return instance.get();
    }

    public List<InstanceName> instanceNames() {
        return this.instances().stream().map(DeploymentInstanceSpec::name).collect(Collectors.toUnmodifiableList());
    }

    public List<DeploymentInstanceSpec> instances() {
        return DeploymentSpec.instances(this.steps);
    }

    private static List<DeploymentInstanceSpec> instances(List<Step> steps) {
        return steps.stream().flatMap(DeploymentSpec::flatten).collect(Collectors.toList());
    }

    private static Stream<DeploymentInstanceSpec> flatten(Step step) {
        if (step instanceof DeploymentInstanceSpec) {
            return Stream.of((DeploymentInstanceSpec)step);
        }
        return step.steps().stream().flatMap(DeploymentSpec::flatten);
    }

    public static DeploymentSpec fromXml(Reader reader) {
        return new DeploymentSpecXmlReader().read(reader);
    }

    public static DeploymentSpec fromXml(String xmlForm) {
        return DeploymentSpec.fromXml(xmlForm, true);
    }

    public static DeploymentSpec fromXml(String xmlForm, boolean validate) {
        return new DeploymentSpecXmlReader(validate).read(xmlForm);
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = t.getMessage();
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentSpec other = (DeploymentSpec)o;
        return this.majorVersion.equals(other.majorVersion) && this.steps.equals(other.steps) && this.xmlForm.equals(other.xmlForm);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.steps, this.xmlForm);
    }

    public static class ChangeBlocker {
        private final boolean revision;
        private final boolean version;
        private final TimeWindow window;

        public ChangeBlocker(boolean revision, boolean version, TimeWindow window) {
            this.revision = revision;
            this.version = version;
            this.window = window;
        }

        public boolean blocksRevisions() {
            return this.revision;
        }

        public boolean blocksVersions() {
            return this.version;
        }

        public TimeWindow window() {
            return this.window;
        }

        public String toString() {
            return "change blocker revision=" + this.revision + " version=" + this.version + " window=" + this.window;
        }
    }

    public static enum UpgradePolicy {
        canary,
        defaultPolicy,
        conservative;

    }

    public static class ParallelSteps
    extends Steps {
        public ParallelSteps(List<Step> steps) {
            super(steps);
        }

        @Override
        public Duration delay() {
            return this.steps().stream().map(Step::delay).max(Comparator.naturalOrder()).orElse(Duration.ZERO);
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParallelSteps)) {
                return false;
            }
            return Objects.equals(this.steps(), ((ParallelSteps)o).steps());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.steps());
        }

        @Override
        public String toString() {
            return this.steps().size() + " parallel steps";
        }
    }

    public static class Steps
    extends Step {
        private final List<Step> steps;

        public Steps(List<Step> steps) {
            this.steps = List.copyOf(steps);
        }

        @Override
        public List<DeclaredZone> zones() {
            return this.steps.stream().flatMap(step -> step.zones().stream()).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public List<Step> steps() {
            return this.steps;
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return this.steps.stream().anyMatch(step -> step.concerns(environment, region));
        }

        @Override
        public Duration delay() {
            return this.steps.stream().map(Step::delay).reduce(Duration.ZERO, Duration::plus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.steps.equals(((Steps)o).steps);
        }

        public int hashCode() {
            return Objects.hash(this.steps);
        }

        public String toString() {
            return this.steps.size() + " steps";
        }
    }

    public static class DeclaredTest
    extends Step {
        private final RegionName region;

        public DeclaredTest(RegionName region) {
            this.region = Objects.requireNonNull(region);
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return region.map(arg_0 -> ((RegionName)this.region).equals(arg_0)).orElse(true) != false && environment == Environment.prod;
        }

        @Override
        public boolean isTest() {
            return true;
        }

        public RegionName region() {
            return this.region;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeclaredTest that = (DeclaredTest)o;
            return this.region.equals((Object)that.region);
        }

        public int hashCode() {
            return Objects.hash(this.region);
        }

        public String toString() {
            return "tests for prod." + this.region;
        }
    }

    public static class DeclaredZone
    extends Step {
        private final Environment environment;
        private final Optional<RegionName> region;
        private final boolean active;
        private final Optional<AthenzService> athenzService;
        private final Optional<String> testerFlavor;

        public DeclaredZone(Environment environment) {
            this(environment, Optional.empty(), false, Optional.empty(), Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active, Optional<AthenzService> athenzService, Optional<String> testerFlavor) {
            if (environment != Environment.prod && region.isPresent()) {
                throw new IllegalArgumentException("Non-prod environments cannot specify a region");
            }
            if (environment == Environment.prod && region.isEmpty()) {
                throw new IllegalArgumentException("Prod environments must be specified with a region");
            }
            this.environment = environment;
            this.region = region;
            this.active = active;
            this.athenzService = athenzService;
            this.testerFlavor = testerFlavor;
        }

        public Environment environment() {
            return this.environment;
        }

        public Optional<RegionName> region() {
            return this.region;
        }

        public boolean active() {
            return this.active;
        }

        public Optional<String> testerFlavor() {
            return this.testerFlavor;
        }

        public Optional<AthenzService> athenzService() {
            return this.athenzService;
        }

        @Override
        public List<DeclaredZone> zones() {
            return Collections.singletonList(this);
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            if (environment != this.environment) {
                return false;
            }
            return !region.isPresent() || region.equals(this.region);
        }

        @Override
        public boolean isTest() {
            return this.environment.isTest();
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.region);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclaredZone)) {
                return false;
            }
            DeclaredZone other = (DeclaredZone)o;
            if (this.environment != other.environment) {
                return false;
            }
            return this.region.equals(other.region());
        }

        public String toString() {
            return this.environment + this.region.map(regionName -> "." + regionName).orElse("");
        }
    }

    public static class Delay
    extends Step {
        private final Duration duration;

        public Delay(Duration duration) {
            this.duration = duration;
        }

        @Override
        public Duration delay() {
            return this.duration;
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return false;
        }

        public String toString() {
            return "delay " + this.duration;
        }
    }

    public static abstract class Step {
        public final boolean concerns(Environment environment) {
            return this.concerns(environment, Optional.empty());
        }

        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return this.concerns(environment, region);
        }

        public abstract boolean concerns(Environment var1, Optional<RegionName> var2);

        public List<DeclaredZone> zones() {
            return Collections.emptyList();
        }

        public Duration delay() {
            return Duration.ZERO;
        }

        public List<Step> steps() {
            return List.of();
        }

        public boolean isTest() {
            return false;
        }

        public boolean isOrdered() {
            return true;
        }
    }
}

