/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SuperModel {
    private final Map<TenantName, Map<ApplicationId, ApplicationInfo>> models;

    public SuperModel() {
        this.models = Collections.emptyMap();
    }

    public SuperModel(Map<TenantName, Map<ApplicationId, ApplicationInfo>> models) {
        this.models = models;
    }

    public Map<TenantName, Map<ApplicationId, ApplicationInfo>> getAllModels() {
        return this.models;
    }

    public Set<ApplicationId> getAllApplicationIds() {
        return this.models.values().stream().flatMap(entry -> entry.keySet().stream()).collect(Collectors.toSet());
    }

    public List<ApplicationInfo> getAllApplicationInfos() {
        return this.models.values().stream().flatMap(entry -> entry.values().stream()).collect(Collectors.toList());
    }

    public Optional<ApplicationInfo> getApplicationInfo(ApplicationId applicationId) {
        Map<ApplicationId, ApplicationInfo> tenantInfo = this.models.get(applicationId.tenant());
        if (tenantInfo == null) {
            return Optional.empty();
        }
        ApplicationInfo applicationInfo = tenantInfo.get(applicationId);
        if (applicationInfo == null) {
            return Optional.empty();
        }
        return Optional.of(applicationInfo);
    }

    public SuperModel cloneAndSetApplication(ApplicationInfo application) {
        TenantName tenant = application.getApplicationId().tenant();
        Map<TenantName, Map<ApplicationId, ApplicationInfo>> newModels = SuperModel.cloneModels(this.models);
        if (!newModels.containsKey(tenant)) {
            newModels.put(tenant, new LinkedHashMap());
        }
        newModels.get(tenant).put(application.getApplicationId(), application);
        return new SuperModel(newModels);
    }

    public SuperModel cloneAndRemoveApplication(ApplicationId applicationId) {
        Map<TenantName, Map<ApplicationId, ApplicationInfo>> newModels = SuperModel.cloneModels(this.models);
        if (newModels.containsKey(applicationId.tenant())) {
            newModels.get(applicationId.tenant()).remove(applicationId);
            if (newModels.get(applicationId.tenant()).isEmpty()) {
                newModels.remove(applicationId.tenant());
            }
        }
        return new SuperModel(newModels);
    }

    private static Map<TenantName, Map<ApplicationId, ApplicationInfo>> cloneModels(Map<TenantName, Map<ApplicationId, ApplicationInfo>> models) {
        LinkedHashMap<TenantName, Map<ApplicationId, ApplicationInfo>> newModels = new LinkedHashMap<TenantName, Map<ApplicationId, ApplicationInfo>>();
        for (Map.Entry<TenantName, Map<ApplicationId, ApplicationInfo>> entry : models.entrySet()) {
            LinkedHashMap<ApplicationId, ApplicationInfo> appMap = new LinkedHashMap<ApplicationId, ApplicationInfo>();
            newModels.put(entry.getKey(), appMap);
            for (Map.Entry<ApplicationId, ApplicationInfo> appEntry : entry.getValue().entrySet()) {
                appMap.put(appEntry.getKey(), appEntry.getValue());
            }
        }
        return newModels;
    }
}

