/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

class CloverChecker {
    private final Log log;

    CloverChecker(Log log) {
        this.log = log;
    }

    public boolean isForkedCloverLifecycle(MavenProject project, Path outputDirectory) {
        return "clover".equals(project.getArtifact().getClassifier()) && project.getCompileSourceRoots().stream().anyMatch(this.equalsPathAbsolutely(this.regularOutputDirectory(project, outputDirectory)));
    }

    private Path regularOutputDirectory(MavenProject project, Path outputDirectory) {
        Path cloverTargetPath = Paths.get(project.getBuild().getDirectory(), new String[0]);
        Path targetPath = cloverTargetPath.getParent();
        if (!targetPath.endsWith("target")) {
            this.log.warn((CharSequence)("Guessing that target directory is " + targetPath + ", this might not be correct."));
        }
        Path outputDirectoryRelativeToCloverDirectory = cloverTargetPath.relativize(outputDirectory);
        return targetPath.resolve(outputDirectoryRelativeToCloverDirectory);
    }

    private Predicate<String> equalsPathAbsolutely(Path path) {
        Path absolutePath = path.toAbsolutePath();
        return candidateStringPath -> Paths.get(candidateStringPath, new String[0]).toAbsolutePath().equals(absolutePath);
    }
}

