/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.VersionSpecification;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import java.nio.ByteBuffer;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private final Utf8Array utf8;
    public static final Version emptyVersion = new Version();

    public Version() {
        this(0, 0, 0, "");
    }

    public Version(int major) {
        this(major, 0, 0, "");
    }

    public Version(int major, int minor) {
        this(major, minor, 0, "");
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, "");
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier != null ? qualifier : "";
        this.utf8 = new Utf8String(this.toString());
        this.verify();
    }

    public Version(String versionString) {
        if (!versionString.isEmpty()) {
            String[] components = versionString.split("\\.");
            try {
                this.major = components.length > 0 ? Integer.parseInt(components[0]) : 0;
                this.minor = components.length > 1 ? Integer.parseInt(components[1]) : 0;
                this.micro = components.length > 2 ? Integer.parseInt(components[2]) : 0;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid version component in '" + versionString + "'", e);
            }
            String string = this.qualifier = components.length > 3 ? components[3] : "";
            if (components.length > 4) {
                throw new IllegalArgumentException("Too many components in '" + versionString + "'");
            }
        } else {
            this.major = 0;
            this.minor = 0;
            this.micro = 0;
            this.qualifier = "";
        }
        this.utf8 = new Utf8String(versionString);
        this.verify();
    }

    private static int readInt(ByteBuffer bb) {
        int accum = 0;
        for (int i = bb.remaining(); i > 0; --i) {
            byte b = bb.get();
            if (b < 48 || b > 57) {
                if (b == 46) {
                    return accum;
                }
                throw new IllegalArgumentException("Failed decoding integer from utf8stream. Stream = " + bb.toString());
            }
            accum = accum * 10 + (b - 48);
        }
        return accum;
    }

    public Version(Utf8Array versionString) {
        ByteBuffer bb = versionString.wrap();
        if (bb.remaining() > 0) {
            this.major = Version.readInt(bb);
            if (bb.remaining() > 0) {
                this.minor = Version.readInt(bb);
                if (bb.remaining() > 0) {
                    this.micro = Version.readInt(bb);
                    this.qualifier = bb.remaining() > 0 ? Utf8.toString((ByteBuffer)bb) : "";
                } else {
                    this.micro = 0;
                    this.qualifier = "";
                }
            } else {
                this.minor = 0;
                this.micro = 0;
                this.qualifier = "";
            }
        } else {
            throw new IllegalArgumentException("Empty version specification");
        }
        this.utf8 = versionString;
        this.verify();
    }

    public static Version fromString(String versionString) {
        return versionString == null ? emptyVersion : new Version(versionString);
    }

    public Version withQualifier(String qualifier) {
        if (qualifier.indexOf(46) != -1) {
            throw new IllegalArgumentException("Qualifier cannot contain '.'");
        }
        return new Version(this.major, this.minor, this.micro, qualifier);
    }

    private void verify() {
        if (this.major < 0) {
            throw new IllegalArgumentException("Negative major in " + this);
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("Negative minor in " + this);
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("Negative micro in " + this);
        }
        for (int i = 0; i < this.qualifier.length(); ++i) {
            char c = this.qualifier.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            throw new IllegalArgumentException("Invalid qualifier in " + this + ": Invalid character at position " + i + " in qualifier");
        }
    }

    private String toStringValue() {
        StringBuilder b = new StringBuilder();
        if (!this.qualifier.isEmpty()) {
            b.append(this.getMajor()).append(".").append(this.getMinor()).append(".").append(this.getMicro()).append(".").append(this.qualifier);
        } else if (this.getMicro() != 0) {
            b.append(this.getMajor()).append(".").append(this.getMinor()).append(".").append(this.getMicro());
        } else if (this.getMinor() != 0) {
            b.append(this.getMajor()).append(".").append(this.getMinor());
        } else if (this.getMajor() != 0) {
            b.append(this.getMajor());
        }
        return b.toString();
    }

    public String toFullString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getMajor()).append(".").append(this.getMinor()).append(".").append(this.getMicro());
        if (!this.qualifier.isEmpty()) {
            b.append(".");
            b.append(this.qualifier);
        }
        return b.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.toStringValue();
    }

    public Utf8Array toUtf8() {
        return this.utf8;
    }

    public int hashCode() {
        return this.major * 3 + this.minor * 5 + this.micro * 7 + this.qualifier.hashCode() * 11;
    }

    public boolean isEmpty() {
        return this.equals(emptyVersion);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        return this.qualifier.equals(other.qualifier);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.getMajor() - other.getMajor();
        if (result != 0) {
            return result;
        }
        result = this.getMinor() - other.getMinor();
        if (result != 0) {
            return result;
        }
        result = this.getMicro() - other.getMicro();
        if (result != 0) {
            return result;
        }
        return this.getQualifier().compareTo(other.getQualifier());
    }

    public boolean isBefore(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(Version other) {
        return this.compareTo(other) > 0;
    }

    public VersionSpecification toSpecification() {
        return this == emptyVersion ? VersionSpecification.emptyVersionSpecification : new VersionSpecification(this.getMajor(), this.getMinor(), this.getMicro(), this.getQualifier());
    }
}

