/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Version;
import com.yahoo.component.VersionSpecification;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentRegistry<COMPONENT> {
    private Map<ComponentId, Map<String, Map<Version, COMPONENT>>> componentsByNameByNamespace = new LinkedHashMap<ComponentId, Map<String, Map<Version, COMPONENT>>>();
    private Map<ComponentId, COMPONENT> componentsById = new LinkedHashMap<ComponentId, COMPONENT>();
    private boolean frozen = false;

    public synchronized void freeze() {
        this.frozen = true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public void register(ComponentId id, COMPONENT component) {
        Map<Version, COMPONENT> componentVersions;
        if (this.frozen) {
            throw new IllegalStateException("Cannot modify a frozen component registry");
        }
        Map<String, Map<Version, COMPONENT>> componentVersionsByName = this.componentsByNameByNamespace.get(id.getNamespace());
        if (componentVersionsByName == null) {
            componentVersionsByName = new LinkedHashMap<String, Map<Version, COMPONENT>>();
            this.componentsByNameByNamespace.put(id.getNamespace(), componentVersionsByName);
        }
        if ((componentVersions = componentVersionsByName.get(id.getName())) == null) {
            componentVersions = new LinkedHashMap<Version, COMPONENT>();
            componentVersionsByName.put(id.getName(), componentVersions);
        }
        componentVersions.put(id.getVersion(), component);
        this.componentsById.put(id, component);
    }

    public COMPONENT unregister(ComponentId id) {
        if (this.frozen) {
            throw new IllegalStateException("Cannot modify a frozen component registry");
        }
        COMPONENT removed = this.componentsById.remove(id);
        if (removed != null) {
            Map<String, Map<Version, COMPONENT>> componentVersionsByName = this.componentsByNameByNamespace.get(id.getNamespace());
            Map<Version, COMPONENT> componentVersions = componentVersionsByName.get(id.getName());
            COMPONENT removedInner = componentVersions.remove(id.getVersion());
            assert (removedInner == removed);
            if (componentVersions.isEmpty()) {
                componentVersionsByName.remove(id.getName());
            }
            if (componentVersionsByName.isEmpty()) {
                this.componentsByNameByNamespace.remove(id.getNamespace());
            }
        }
        return removed;
    }

    public COMPONENT getComponent(String componentSpecification) {
        return this.getComponent(new ComponentSpecification(componentSpecification));
    }

    public COMPONENT getComponent(ComponentId id) {
        return this.componentsById.get(id);
    }

    public COMPONENT getComponent(ComponentSpecification id) {
        Map<String, Map<Version, COMPONENT>> componentVersionsByName = this.componentsByNameByNamespace.get(id.getNamespace());
        if (componentVersionsByName == null) {
            return null;
        }
        Map<Version, COMPONENT> versions = componentVersionsByName.get(id.getName());
        if (versions == null) {
            return null;
        }
        Version version = ComponentRegistry.findBestMatch(id.getVersionSpecification(), versions.keySet());
        return versions.get(version);
    }

    protected static Version findBestMatch(VersionSpecification versionSpec, Set<Version> versions) {
        Version bestMatch = null;
        for (Version version : versions) {
            if (version == null || !versionSpec.matches(version) || bestMatch != null && bestMatch.compareTo(version) >= 0) continue;
            bestMatch = version;
        }
        return bestMatch;
    }

    public List<COMPONENT> allComponents() {
        return ImmutableList.copyOf(this.componentsById.values());
    }

    public Map<ComponentId, COMPONENT> allComponentsById() {
        return ImmutableMap.copyOf(this.componentsById);
    }

    public int getComponentCount() {
        return this.componentsById.size();
    }

    public static <COMPONENT> ComponentRegistry<COMPONENT> singleton(ComponentId id, COMPONENT component) {
        ComponentRegistry<COMPONENT> registry = new ComponentRegistry<COMPONENT>();
        registry.register(id, component);
        registry.freeze();
        return registry;
    }
}

