/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.async.PipedAsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClientWithBase;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingAsyncHttpClient<T extends HttpResult>
extends AsyncHttpClientWithBase<T> {
    private static final Logger log = Logger.getLogger(LoggingAsyncHttpClient.class.getName());
    private int requestCounter = 0;

    public LoggingAsyncHttpClient(AsyncHttpClient<T> client) {
        super(client);
        log.info("Logging HTTP requests if fine logging level is added");
    }

    @Override
    public AsyncOperation<T> execute(HttpRequest r) {
        final int requestCount = ++this.requestCounter;
        log.fine("Issuing HTTP request " + requestCount + ": " + r.toString(true));
        final AsyncOperation op = this.client.execute(r);
        return new PipedAsyncOperation<T, T>(op){

            @Override
            public T convertResult(T result) {
                if (log.isLoggable(Level.FINE)) {
                    if (op.isSuccess()) {
                        log.fine("HTTP request " + requestCount + " completed: " + ((HttpResult)result).toString(true));
                    } else {
                        StringWriter sw = new StringWriter();
                        op.getCause().printStackTrace(new PrintWriter(sw));
                        log.fine("HTTP request " + requestCount + " failed: " + sw);
                    }
                }
                return result;
            }
        };
    }
}

