/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.util.CertainlyCloneable;
import java.util.LinkedList;
import java.util.List;

public class HttpRequest
extends CertainlyCloneable<HttpRequest> {
    private String scheme;
    private String host;
    private int port;
    private String path;
    private List<KeyValuePair> urlOptions = new LinkedList<KeyValuePair>();
    private List<KeyValuePair> headers = new LinkedList<KeyValuePair>();
    private long timeoutMillis;
    private Object postContent;
    private HttpOp httpOperation;

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public List<KeyValuePair> getUrlOptions() {
        return this.urlOptions;
    }

    public String getOption(String key, String defaultValue) {
        for (KeyValuePair value : this.urlOptions) {
            if (!value.key.equals(key)) continue;
            return value.value;
        }
        return defaultValue;
    }

    public List<KeyValuePair> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key, String defaultValue) {
        for (KeyValuePair header : this.headers) {
            if (!header.key.equals(key)) continue;
            return header.value;
        }
        return defaultValue;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public Object getPostContent() {
        return this.postContent;
    }

    public HttpOp getHttpOperation() {
        return this.httpOperation;
    }

    public HttpRequest setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpRequest setHost(String hostname) {
        this.host = hostname;
        return this;
    }

    public HttpRequest setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public HttpRequest addUrlOption(String key, String value) {
        this.urlOptions.add(new KeyValuePair(key, value));
        return this;
    }

    public HttpRequest setUrlOptions(List<KeyValuePair> options) {
        this.urlOptions.clear();
        this.urlOptions.addAll(options);
        return this;
    }

    public HttpRequest addHttpHeader(String key, String value) {
        this.headers.add(new KeyValuePair(key, value));
        return this;
    }

    public HttpRequest setTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public HttpRequest setPostContent(Object content) {
        this.postContent = content;
        return this;
    }

    public HttpRequest setHttpOperation(HttpOp op) {
        this.httpOperation = op;
        return this;
    }

    public HttpRequest merge(HttpRequest r) {
        boolean containsElement;
        HttpRequest copy = this.clone();
        if (r.scheme != null) {
            copy.scheme = r.scheme;
        }
        if (r.host != null) {
            copy.host = r.host;
        }
        if (r.port != 0) {
            copy.port = r.port;
        }
        if (r.path != null) {
            copy.path = r.path;
        }
        for (KeyValuePair h : r.headers) {
            containsElement = false;
            for (KeyValuePair h2 : copy.headers) {
                containsElement |= h.key.equals(h2.key);
            }
            if (containsElement) continue;
            copy.headers.add(h);
        }
        for (KeyValuePair h : r.urlOptions) {
            containsElement = false;
            for (KeyValuePair h2 : copy.urlOptions) {
                containsElement |= h.key.equals(h2.key);
            }
            if (containsElement) continue;
            copy.urlOptions.add(h);
        }
        if (r.timeoutMillis != 0L) {
            copy.timeoutMillis = r.timeoutMillis;
        }
        if (r.postContent != null) {
            copy.postContent = r.postContent;
        }
        if (r.httpOperation != null) {
            copy.httpOperation = r.httpOperation;
        }
        return copy;
    }

    @Override
    public HttpRequest clone() {
        HttpRequest r = (HttpRequest)super.clone();
        r.headers = new LinkedList<KeyValuePair>(r.headers);
        r.urlOptions = new LinkedList<KeyValuePair>(r.urlOptions);
        return r;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        String httpOp = this.httpOperation != null ? this.httpOperation.toString() : (this.postContent == null ? "GET?" : "POST?");
        StringBuilder sb = new StringBuilder().append(httpOp).append(" ").append(this.scheme).append(':');
        if (this.host != null) {
            sb.append("//").append(this.host);
            if (this.port != 0) {
                sb.append(':').append(this.port);
            }
        }
        if (this.path == null || this.path.isEmpty()) {
            sb.append('/');
        } else {
            if (this.path.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(this.path);
        }
        if (this.urlOptions != null && this.urlOptions.size() > 0) {
            boolean first = this.path == null || this.path.indexOf(63) < 0;
            for (KeyValuePair e : this.urlOptions) {
                sb.append(first ? (char)'?' : '&');
                first = false;
                sb.append(e.key).append('=').append(e.value);
            }
        }
        if (verbose) {
            for (KeyValuePair p : this.headers) {
                sb.append('\n').append(p.key).append(": ").append(p.value);
            }
            if (this.postContent != null && !this.postContent.toString().isEmpty()) {
                sb.append("\n\n").append(this.postContent.toString());
            }
        }
        return sb.toString();
    }

    public void verifyComplete() {
        if (this.path == null) {
            throw new IllegalStateException("HTTP requests must have a path set. Use '/' for top level");
        }
        if (this.httpOperation == null) {
            throw new IllegalStateException("HTTP requests must have an HTTP method defined");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof HttpRequest) {
            return this.toString(true).equals(((HttpRequest)o).toString(true));
        }
        return false;
    }

    public int hashCode() {
        return this.toString(true).hashCode();
    }

    public static enum HttpOp {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static class KeyValuePair {
        public String key;
        public String value;

        public KeyValuePair(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }
    }
}

