/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.test;

import com.yahoo.vespa.clustercontroller.utils.test.SettableClock;
import java.util.logging.Logger;

public class FakeClock
extends SettableClock {
    private static final Logger logger = Logger.getLogger(FakeClock.class.getName());
    protected long currentTime = 1L;

    @Override
    public long getTimeInMillis() {
        return this.currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjust(long adjustment) {
        FakeClock fakeClock = this;
        synchronized (fakeClock) {
            logger.fine("Adjusting clock, adding " + adjustment + " ms to it.");
            this.currentTime += adjustment;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long newTime) {
        FakeClock fakeClock = this;
        synchronized (fakeClock) {
            if (newTime < this.currentTime) {
                // empty if block
            }
            this.currentTime = newTime;
        }
    }
}

