/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.test;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperationImpl;
import com.yahoo.vespa.clustercontroller.utils.communication.http.AsyncHttpClient;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequestHandler;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestTransport {
    private static final Logger log = Logger.getLogger(TestTransport.class.getName());
    private final Map<Socket, List<Handler>> handlers = new HashMap<Socket, List<Handler>>();
    private final LinkedList<Request> requests = new LinkedList();
    private final AsyncHttpClient<HttpResult> client = new AsyncHttpClient<HttpResult>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AsyncOperation<HttpResult> execute(HttpRequest r) {
            log.fine("Queueing request " + r);
            if (r.getHttpOperation() == null) {
                r.setHttpOperation((r = r.clone()).getPostContent() == null ? HttpRequest.HttpOp.GET : HttpRequest.HttpOp.POST);
            }
            r.verifyComplete();
            AsyncOperationImpl<HttpResult> op = new AsyncOperationImpl<HttpResult>(r.toString());
            LinkedList linkedList = TestTransport.this.requests;
            synchronized (linkedList) {
                TestTransport.this.requests.addLast(new Request(r, op));
            }
            return op;
        }

        @Override
        public void close() {
            TestTransport.this.close();
        }
    };
    private boolean running = true;
    private final Thread workerThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TestTransport.this.running) {
                LinkedList linkedList = TestTransport.this.requests;
                synchronized (linkedList) {
                    if (TestTransport.this.requests.isEmpty()) {
                        try {
                            TestTransport.this.requests.wait(100L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    Request request = (Request)TestTransport.this.requests.removeFirst();
                    HttpRequest r = request.request;
                    log.fine("Processing request " + r);
                    HttpRequestHandler handler = TestTransport.this.getHandler(r);
                    if (handler == null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Failed to find target for request " + r.toString(true));
                            log.fine("Existing handlers:");
                            for (Socket socket : TestTransport.this.handlers.keySet()) {
                                log.fine("  Socket " + socket.hostname + ":" + socket.port);
                                for (Handler h : (List)TestTransport.this.handlers.get(socket)) {
                                    log.fine("    " + h.pathPrefix);
                                }
                            }
                        }
                        request.result.setResult(new HttpResult().setHttpCode(404, "No such server socket with suitable path prefix found open"));
                    } else {
                        try {
                            request.result.setResult(handler.handleRequest(r));
                        }
                        catch (Exception e) {
                            HttpResult result = new HttpResult().setHttpCode(500, e.getMessage());
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            result.setContent(sw.toString());
                            request.result.setResult(result);
                        }
                    }
                }
            }
        }
    };

    public TestTransport() {
        this.workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.running) {
            return;
        }
        this.running = false;
        LinkedList<Request> linkedList = this.requests;
        synchronized (linkedList) {
            this.requests.notifyAll();
        }
        try {
            this.workerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public AsyncHttpClient<HttpResult> getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestHandler getHandler(HttpRequest r) {
        Socket socket = new Socket(r.getHost(), r.getPort());
        TestTransport testTransport = this;
        synchronized (testTransport) {
            List<Handler> handlerList = this.handlers.get(socket);
            if (handlerList == null) {
                log.fine("No socket match");
                return null;
            }
            log.fine("Socket found");
            for (Handler h : this.handlers.get(socket)) {
                if (r.getPath().length() < h.pathPrefix.length() || !r.getPath().substring(0, h.pathPrefix.length()).equals(h.pathPrefix)) continue;
                return h.handler;
            }
            log.fine("No path prefix match");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(HttpRequestHandler server, String hostname, int port, String pathPrefix) {
        Socket socket = new Socket(hostname, port);
        TestTransport testTransport = this;
        synchronized (testTransport) {
            List<Handler> shandlers = this.handlers.get(socket);
            if (shandlers == null) {
                shandlers = new LinkedList<Handler>();
                this.handlers.put(socket, shandlers);
            }
            shandlers.add(new Handler(server, pathPrefix));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(HttpRequestHandler server, String hostname, int port, String pathPrefix) {
        Socket socket = new Socket(hostname, port);
        TestTransport testTransport = this;
        synchronized (testTransport) {
            List<Handler> shandlers = this.handlers.get(socket);
            if (shandlers == null) {
                return;
            }
            for (Handler h : shandlers) {
                if (h.handler != server || !h.pathPrefix.equals(pathPrefix)) continue;
                shandlers.remove(h);
            }
        }
    }

    private static class Request {
        public final HttpRequest request;
        public final AsyncOperationImpl<HttpResult> result;

        Request(HttpRequest r, AsyncOperationImpl<HttpResult> rr) {
            this.request = r;
            this.result = rr;
        }
    }

    private static class Socket {
        public final String hostname;
        public final int port;

        Socket(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Socket)) {
                return false;
            }
            Socket other = (Socket)o;
            return this.hostname.equals(other.hostname) && this.port == other.port;
        }

        public int hashCode() {
            return this.hostname.hashCode() * this.port;
        }
    }

    private static class Handler {
        HttpRequestHandler handler;
        String pathPrefix;

        Handler(HttpRequestHandler h, String prefix) {
            this.handler = h;
            this.pathPrefix = prefix;
        }
    }
}

