/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.osgi.ImportPackages;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Packages {
    public static String packageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fullClassName.substring(0, index);
    }

    public static List<String> disallowedImports(Map<String, ImportPackages.Import> imports, List<String> disallowed) {
        if (imports == null || imports.isEmpty()) {
            return List.of();
        }
        HashSet<String> importedSet = new HashSet<String>(imports.keySet());
        HashSet<String> disallowedSet = disallowed == null ? Set.of() : new HashSet<String>(disallowed);
        return importedSet.stream().filter(disallowedSet::contains).sorted().toList();
    }

    public static PackageMetaData analyzePackages(Set<ClassFileMetaData> allClasses) {
        HashSet<String> definedPackages = new HashSet<String>();
        HashSet<String> referencedPackages = new HashSet<String>();
        for (ClassFileMetaData metaData : allClasses) {
            definedPackages.add(Packages.packageName(metaData.getName()));
            metaData.getReferencedClasses().forEach(className -> referencedPackages.add(Packages.packageName(className)));
        }
        referencedPackages.removeAll(definedPackages);
        return new PackageMetaData(definedPackages, referencedPackages);
    }

    public static class PackageMetaData {
        public final Set<String> definedPackages;
        public final Set<String> referencedExternalPackages;

        public PackageMetaData(Set<String> definedPackages, Set<String> referencedExternalPackages) {
            this.definedPackages = definedPackages;
            this.referencedExternalPackages = referencedExternalPackages;
        }
    }
}

