/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ExportPackageAnnotation;
import com.yahoo.container.plugin.classanalysis.PackageTally;
import com.yahoo.container.plugin.osgi.ExportPackageParser;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.osgi.ImportPackages;
import com.yahoo.container.plugin.util.IO;
import com.yahoo.container.plugin.util.Strings;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class AbstractGenerateOsgiManifestMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    MavenProject project;
    @Parameter(alias="UseArtifactVersionForExportPackages", defaultValue="false")
    boolean useArtifactVersionForExportPackages;
    @Parameter(alias="Bundle-Version", defaultValue="${project.version}")
    String bundleVersion;
    @Parameter(alias="Bundle-SymbolicName", defaultValue="${project.artifactId}")
    String bundleSymbolicName;
    @Parameter(alias="Import-Package")
    String importPackage;
    @Parameter(alias="SPI-Provider")
    String spiProvider;
    @Parameter(alias="SPI-Consumer")
    String spiConsumer;

    AbstractGenerateOsgiManifestMojo() {
    }

    Map<String, String> generateManifestContent(Collection<Artifact> jarArtifactsToInclude, Map<String, ImportPackages.Import> calculatedImports, PackageTally pluginPackageTally) {
        Map<String, Optional<String>> manualImports = this.getManualImports();
        for (String packageName : manualImports.keySet()) {
            calculatedImports.remove(packageName);
        }
        Collection<ImportPackages.Import> imports = calculatedImports.values();
        HashMap<String, String> ret = new HashMap<String, String>();
        String importPackage = Stream.concat(manualImports.entrySet().stream().map(e -> AbstractGenerateOsgiManifestMojo.asOsgiImport((String)e.getKey(), (Optional)e.getValue())), imports.stream().map(ImportPackages.Import::asOsgiImport)).sorted().collect(Collectors.joining(","));
        String exportPackage = this.osgiExportPackages(pluginPackageTally.exportedPackages()).stream().sorted().collect(Collectors.joining(","));
        ret.put("Created-By", "vespa container maven plugin");
        ret.put("Bundle-ManifestVersion", "2");
        ret.put("Bundle-Name", this.project.getName());
        ret.put("Bundle-SymbolicName", this.bundleSymbolicName);
        ret.put("Bundle-Version", AbstractGenerateOsgiManifestMojo.asBundleVersion(this.bundleVersion));
        ret.put("Bundle-Vendor", "Yahoo!");
        AbstractGenerateOsgiManifestMojo.addIfNotEmpty(ret, "Bundle-ClassPath", AbstractGenerateOsgiManifestMojo.bundleClassPath(jarArtifactsToInclude));
        AbstractGenerateOsgiManifestMojo.addIfNotEmpty(ret, "Import-Package", importPackage);
        AbstractGenerateOsgiManifestMojo.addIfNotEmpty(ret, "Export-Package", exportPackage);
        AbstractGenerateOsgiManifestMojo.addIfNotEmpty(ret, "SPI-Provider", this.spiProvider);
        AbstractGenerateOsgiManifestMojo.addIfNotEmpty(ret, "SPI-Consumer", this.spiConsumer);
        return ret;
    }

    PackageTally definedPackages(Collection<Artifact> jarArtifacts) {
        ArrayList<PackageTally> tallies = new ArrayList<PackageTally>();
        for (Artifact artifact : jarArtifacts) {
            try {
                tallies.add(AbstractGenerateOsgiManifestMojo.definedPackages(new JarFile(artifact.getFile()), this.artifactVersionOrNull(artifact.getVersion())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return PackageTally.combine(tallies);
    }

    ArtifactVersion artifactVersionOrNull(String version) {
        return this.useArtifactVersionForExportPackages ? new DefaultArtifactVersion(version) : null;
    }

    static void createManifestFile(Path outputDirectory, Map<String, String> manifestContent) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifestContent.forEach(mainAttributes::putValue);
        IO.withFileOutputStream(outputDirectory.resolve("META-INF/MANIFEST.MF").toFile(), out -> {
            manifest.write((OutputStream)out);
            return null;
        });
    }

    static void addIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    private Collection<String> osgiExportPackages(Map<String, ExportPackageAnnotation> exportedPackages) {
        return exportedPackages.entrySet().stream().map(entry -> (String)entry.getKey() + ";version=" + ((ExportPackageAnnotation)entry.getValue()).osgiVersion()).toList();
    }

    private static String asOsgiImport(String packageName, Optional<String> version) {
        return version.map(s -> packageName + ";version=\"" + s + "\"").orElse(packageName);
    }

    private static String bundleClassPath(Collection<Artifact> artifactsToInclude) {
        return Stream.concat(Stream.of("."), artifactsToInclude.stream().map(artifact -> "dependencies/" + artifact.getFile().getName())).collect(Collectors.joining(","));
    }

    private Map<String, Optional<String>> getManualImports() {
        try {
            if (this.importPackage == null || this.importPackage.isBlank()) {
                return Map.of();
            }
            HashMap<String, Optional<String>> ret = new HashMap<String, Optional<String>>();
            List<ExportPackages.Export> imports = ExportPackageParser.parseExports(this.importPackage);
            for (ExportPackages.Export imp : imports) {
                Optional<String> version = AbstractGenerateOsgiManifestMojo.getVersionThrowOthers(imp.getParameters());
                imp.getPackageNames().forEach(pn -> ret.put((String)pn, version));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in Import-Package:" + this.importPackage, e);
        }
    }

    private static String asBundleVersion(String projectVersion) {
        if (projectVersion == null) {
            throw new IllegalArgumentException("Missing project version.");
        }
        String[] parts = projectVersion.split("-", 2);
        List numericPart = Stream.of(parts[0].split("\\.")).map(s -> Strings.replaceEmptyString(s, "0")).limit(3L).collect(Collectors.toList());
        while (numericPart.size() < 3) {
            numericPart.add("0");
        }
        return String.join((CharSequence)".", numericPart);
    }

    private static Optional<String> getVersionThrowOthers(List<ExportPackages.Parameter> parameters) {
        if (parameters.size() == 1 && "version".equals(parameters.get(0).getName())) {
            return Optional.of(parameters.get(0).getValue());
        }
        if (parameters.size() == 0) {
            return Optional.empty();
        }
        List<String> paramNames = parameters.stream().map(ExportPackages.Parameter::getName).toList();
        throw new RuntimeException("A single, optional version parameter expected, but got " + paramNames);
    }

    private static PackageTally definedPackages(JarFile jarFile, ArtifactVersion version) throws MojoExecutionException {
        ArrayList<ClassFileMetaData> analyzedClasses = new ArrayList<ClassFileMetaData>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            analyzedClasses.add(AbstractGenerateOsgiManifestMojo.analyzeClass(jarFile, entry, version));
        }
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }

    private static ClassFileMetaData analyzeClass(JarFile jarFile, JarEntry entry, ArtifactVersion version) throws MojoExecutionException {
        try {
            return Analyze.analyzeClass(jarFile.getInputStream(entry), version);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("While analyzing the class '%s' in jar file '%s'", entry.getName(), jarFile.getName()), e);
        }
    }
}

