/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.osgi;

import com.yahoo.container.plugin.osgi.ExportPackages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExportPackageParser {
    private static Pattern STRING_LITERAL_PATTERN = Pattern.compile("\"(?:[^\"\\p{Cntrl}\\\\]|\\\\[\\\\'\"bfnrt]|\\\\u[0-9a-fA-F]{4})+\"");
    private static Pattern EXTENDED_PATTERN = Pattern.compile("[\\p{Alnum}_.-]+");
    private static Pattern DIRECTIVE_OR_ATTRIBUTE_SEPARATOR_PATTERN = Pattern.compile("\\s*:?=\\s*");
    private static Pattern PARAMETER_SEPARATOR_PATTERN = Pattern.compile("\\s*;\\s*");
    private static Pattern EXPORT_SEPARATOR_PATTERN = Pattern.compile("\\s*,\\s*");

    public static List<ExportPackages.Export> parseExports(String exportAttribute) {
        ParsingContext p = new ParsingContext(exportAttribute.trim());
        List<ExportPackages.Export> exports = ExportPackageParser.parseExportPackage(p);
        if (exports.isEmpty()) {
            p.fail("Expected a list of exports");
        } else if (!p.atEnd()) {
            p.fail("Exports not fully processed");
        }
        return exports;
    }

    private static Optional<String> parseIdent(ParsingContext p) {
        Optional<String> ident = p.read(ctx -> {
            if (ctx.length == 0) {
                if (!Character.isJavaIdentifierStart(ctx.ch)) {
                    ctx.invalid();
                }
            } else if (!Character.isJavaIdentifierPart(ctx.ch)) {
                ctx.end();
            }
        });
        return ident;
    }

    private static Optional<String> parseStringLiteral(ParsingContext p) {
        return p.regexp(STRING_LITERAL_PATTERN).map(quoted -> quoted.substring(1, quoted.length() - 1));
    }

    private static Optional<String> parseExtended(ParsingContext p) {
        return p.regexp(EXTENDED_PATTERN);
    }

    private static String parseArgument(ParsingContext p) {
        Optional<String> argument = ExportPackageParser.parseExtended(p);
        if (!argument.isPresent()) {
            argument = ExportPackageParser.parseStringLiteral(p);
        }
        if (!argument.isPresent()) {
            p.fail("Expected an extended token or a string literal");
        }
        return argument.get();
    }

    private static Optional<ExportPackages.Parameter> parseParameter(ParsingContext p) {
        int backtrack = p.pos;
        Optional<String> ext = ExportPackageParser.parseExtended(p);
        if (ext.isPresent()) {
            Optional<String> sep = p.regexp(DIRECTIVE_OR_ATTRIBUTE_SEPARATOR_PATTERN);
            if (!sep.isPresent()) {
                p.pos = backtrack;
                return Optional.empty();
            }
            String argument = ExportPackageParser.parseArgument(p);
            return Optional.of(new ExportPackages.Parameter(ext.get(), argument));
        }
        return Optional.empty();
    }

    private static List<ExportPackages.Parameter> parseParameters(ParsingContext p) {
        ArrayList<ExportPackages.Parameter> params = new ArrayList<ExportPackages.Parameter>();
        boolean wantMore = true;
        do {
            Optional<ExportPackages.Parameter> param;
            if ((param = ExportPackageParser.parseParameter(p)).isPresent()) {
                params.add(param.get());
                wantMore = p.regexp(PARAMETER_SEPARATOR_PATTERN).isPresent();
                continue;
            }
            wantMore = false;
        } while (wantMore);
        return params;
    }

    private static Optional<String> parsePackageName(ParsingContext p) {
        StringBuilder ret = new StringBuilder();
        boolean wantMore = true;
        do {
            Optional<String> ident;
            if ((ident = ExportPackageParser.parseIdent(p)).isPresent()) {
                ret.append(ident.get());
                Optional<String> separator = p.exactly(".");
                if (separator.isPresent()) {
                    ret.append(separator.get());
                    wantMore = true;
                    continue;
                }
                wantMore = false;
                continue;
            }
            wantMore = false;
        } while (wantMore);
        if (ret.length() > 0) {
            return Optional.of(ret.toString());
        }
        return Optional.empty();
    }

    private static ExportPackages.Export parseExport(ParsingContext p) {
        ArrayList<String> exports = new ArrayList<String>();
        boolean wantMore = true;
        do {
            List<ExportPackages.Parameter> params;
            if (!exports.isEmpty() && !(params = ExportPackageParser.parseParameters(p)).isEmpty()) {
                return new ExportPackages.Export(exports, params);
            }
            Optional<String> packageName = ExportPackageParser.parsePackageName(p);
            if (packageName.isPresent()) {
                exports.add(packageName.get());
                continue;
            }
            p.fail(exports.isEmpty() ? "Expected a package name" : "Expected either a package name or a parameter list");
        } while (wantMore = p.regexp(PARAMETER_SEPARATOR_PATTERN).isPresent());
        return new ExportPackages.Export(exports, new ArrayList<ExportPackages.Parameter>());
    }

    private static List<ExportPackages.Export> parseExportPackage(ParsingContext p) {
        ArrayList<ExportPackages.Export> exports = new ArrayList<ExportPackages.Export>();
        boolean wantMore = true;
        do {
            ExportPackages.Export export;
            if ((export = ExportPackageParser.parseExport(p)).getPackageNames().isEmpty()) {
                wantMore = false;
                continue;
            }
            exports.add(export);
            wantMore = p.regexp(EXPORT_SEPARATOR_PATTERN).isPresent();
        } while (wantMore);
        return exports;
    }

    private static class ParsingContext {
        private CharSequence input;
        private int pos;
        private State state;
        private int length;
        private char ch;

        private ParsingContext(CharSequence input) {
            this.input = input;
            this.pos = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Optional<String> read(Consumer<ParsingContext> rule) {
            StringBuilder ret = new StringBuilder();
            block5: while (this.input.length() >= this.pos + 1) {
                this.ch = this.input.charAt(this.pos);
                this.state = State.WantMore;
                this.length = ret.length();
                rule.accept(this);
                switch (this.state) {
                    case Invalid: {
                        if (ret.length() == 0) break block5;
                        String printable = Character.isISOControl(this.ch) ? "#" + Integer.toString(this.ch) : "[" + Character.toString(this.ch) + "]";
                        ++this.pos;
                        this.fail("Character " + printable + " was not acceptable");
                        break;
                    }
                    case WantMore: {
                        ret.append(this.ch);
                        ++this.pos;
                        break;
                    }
                    case End: {
                        break block5;
                    }
                }
            }
            if (ret.length() == 0) {
                return Optional.empty();
            }
            return Optional.of(ret.toString());
        }

        private Optional<String> regexp(Pattern pattern) {
            Matcher matcher = pattern.matcher(this.input);
            matcher.region(this.pos, this.input.length());
            if (matcher.lookingAt()) {
                String value = matcher.group();
                this.pos += value.length();
                return Optional.of(value);
            }
            return Optional.empty();
        }

        private Optional<String> exactly(String string) {
            if (this.input.length() - this.pos < string.length()) {
                return Optional.empty();
            }
            if (this.input.subSequence(this.pos, this.pos + string.length()).equals(string)) {
                this.pos += string.length();
                return Optional.of(string);
            }
            return Optional.empty();
        }

        private boolean atEnd() {
            return this.pos == this.input.length();
        }

        private void invalid() {
            this.state = State.Invalid;
        }

        private void end() {
            this.state = State.End;
        }

        private void fail(String message) {
            throw new RuntimeException("Failed parsing Export-Package: " + message + " at position " + this.pos);
        }

        private static enum State {
            Invalid,
            WantMore,
            End;

        }
    }
}

