/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.mojo.TestProvidedArtifacts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class Artifacts {
    Artifacts() {
    }

    static ArtifactSet getArtifacts(MavenProject project) {
        return Artifacts.getArtifacts(project, false, null);
    }

    static ArtifactSet getArtifacts(MavenProject project, boolean includeTestArtifacts, String testProvidedConfig) {
        TestProvidedArtifacts testProvidedArtifacts = TestProvidedArtifacts.from(project.getArtifactMap(), testProvidedConfig);
        ArrayList<Artifact> jarArtifactsToInclude = new ArrayList<Artifact>();
        ArrayList<Artifact> jarArtifactsProvided = new ArrayList<Artifact>();
        ArrayList<Artifact> nonJarArtifactsToInclude = new ArrayList<Artifact>();
        ArrayList<Artifact> nonJarArtifactsProvided = new ArrayList<Artifact>();
        for (Artifact artifact : project.getArtifacts()) {
            if ("jar".equals(artifact.getType())) {
                if (includeTestArtifacts && testProvidedArtifacts.isTestProvided(artifact)) {
                    jarArtifactsProvided.add(artifact);
                    continue;
                }
                if ("compile".equals(artifact.getScope())) {
                    jarArtifactsToInclude.add(artifact);
                    continue;
                }
                if ("provided".equals(artifact.getScope())) {
                    jarArtifactsProvided.add(artifact);
                    continue;
                }
                if (!includeTestArtifacts || !"test".equals(artifact.getScope())) continue;
                jarArtifactsToInclude.add(artifact);
                continue;
            }
            if ("compile".equals(artifact.getScope())) {
                nonJarArtifactsToInclude.add(artifact);
                continue;
            }
            if (!"provided".equals(artifact.getScope())) continue;
            nonJarArtifactsProvided.add(artifact);
        }
        nonJarArtifactsToInclude.addAll(nonJarArtifactsProvided);
        return new ArtifactSet(jarArtifactsToInclude, jarArtifactsProvided, nonJarArtifactsToInclude);
    }

    static Collection<Artifact> getArtifactsToInclude(MavenProject project) {
        return Artifacts.getArtifacts(project, false, null).getJarArtifactsToInclude();
    }

    static class ArtifactSet {
        private final List<Artifact> jarArtifactsToInclude;
        private final List<Artifact> jarArtifactsProvided;
        private final List<Artifact> nonJarArtifacts;

        private ArtifactSet(List<Artifact> jarArtifactsToInclude, List<Artifact> jarArtifactsProvided, List<Artifact> nonJarArtifacts) {
            this.jarArtifactsToInclude = jarArtifactsToInclude;
            this.jarArtifactsProvided = jarArtifactsProvided;
            this.nonJarArtifacts = nonJarArtifacts;
        }

        List<Artifact> getJarArtifactsToInclude() {
            return this.jarArtifactsToInclude;
        }

        List<Artifact> getJarArtifactsProvided() {
            return this.jarArtifactsProvided;
        }

        List<Artifact> getNonJarArtifacts() {
            return this.nonJarArtifacts;
        }
    }
}

