/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.ResourceQuotas;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.naming.NamespaceName;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import com.yahoo.pulsar.common.policies.data.ResourceQuota;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class ResourceQuotasImpl
extends BaseResource
implements ResourceQuotas {
    private final WebTarget quotas;

    public ResourceQuotasImpl(WebTarget web, Authentication auth) {
        super(auth);
        this.quotas = web.path("/resource-quotas");
    }

    @Override
    public ResourceQuota getDefaultResourceQuota() throws PulsarAdminException {
        try {
            return (ResourceQuota)this.request(this.quotas).get(ResourceQuota.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setDefaultResourceQuota(ResourceQuota quota) throws PulsarAdminException {
        try {
            this.request(this.quotas).post(Entity.entity((Object)quota, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public ResourceQuota getNamespaceBundleResourceQuota(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (ResourceQuota)this.request(this.quotas.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle)).get(ResourceQuota.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceBundleResourceQuota(String namespace, String bundle, ResourceQuota quota) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.quotas.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle)).post(Entity.entity((Object)quota, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void resetNamespaceBundleResourceQuota(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.quotas.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle)).delete();
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

