/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.Namespaces;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.naming.NamespaceName;
import com.yahoo.pulsar.common.policies.data.AuthAction;
import com.yahoo.pulsar.common.policies.data.BacklogQuota;
import com.yahoo.pulsar.common.policies.data.BundlesData;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import com.yahoo.pulsar.common.policies.data.PersistencePolicies;
import com.yahoo.pulsar.common.policies.data.Policies;
import com.yahoo.pulsar.common.policies.data.RetentionPolicies;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class NamespacesImpl
extends BaseResource
implements Namespaces {
    private final WebTarget namespaces;

    public NamespacesImpl(WebTarget web, Authentication auth) {
        super(auth);
        this.namespaces = web.path("/namespaces");
    }

    @Override
    public List<String> getNamespaces(String property) throws PulsarAdminException {
        try {
            return (List)this.request(this.namespaces.path(property)).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getNamespaces(String property, String cluster) throws PulsarAdminException {
        try {
            return (List)this.request(this.namespaces.path(property).path(cluster)).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getDestinations(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (List)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("destinations")).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Policies getPolicies(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (Policies)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName())).get(Policies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespace(String namespace, int numBundles) throws PulsarAdminException {
        this.createNamespace(namespace, new BundlesData(numBundles));
    }

    @Override
    public void createNamespace(String namespace, BundlesData bundlesData) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName())).put(Entity.entity((Object)bundlesData, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespace(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName())).put(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteNamespace(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName())).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteNamespaceBundle(String namespace, String bundleRange) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundleRange)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, Set<AuthAction>> getPermissions(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (Map)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("permissions")).get((GenericType)new GenericType<Map<String, Set<AuthAction>>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void grantPermissionOnNamespace(String namespace, String role, Set<AuthAction> actions) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("permissions").path(role)).post(Entity.entity(actions, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void revokePermissionsOnNamespace(String namespace, String role) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("permissions").path(role)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getNamespaceReplicationClusters(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (List)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("replication")).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceReplicationClusters(String namespace, List<String> clusterIds) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("replication")).post(Entity.entity(clusterIds, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public int getNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (Integer)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("messageTTL")).get((GenericType)new GenericType<Integer>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setNamespaceMessageTTL(String namespace, int ttlInSeconds) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("messageTTL")).post(Entity.entity((Object)ttlInSeconds, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (Map)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("backlogQuotaMap")).get((GenericType)new GenericType<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setBacklogQuota(String namespace, BacklogQuota backlogQuota) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("backlogQuota")).post(Entity.entity((Object)backlogQuota, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void removeBacklogQuota(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("backlogQuota").queryParam("backlogQuotaType", new Object[]{BacklogQuota.BacklogQuotaType.destination_storage.toString()})).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setPersistence(String namespace, PersistencePolicies persistence) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("persistence")).post(Entity.entity((Object)persistence, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public PersistencePolicies getPersistence(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (PersistencePolicies)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("persistence")).get(PersistencePolicies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setRetention(String namespace, RetentionPolicies retention) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("retention")).post(Entity.entity((Object)retention, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public RetentionPolicies getRetention(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (RetentionPolicies)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("retention")).get(RetentionPolicies.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unload(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("unload")).put(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public String getReplicationConfigVersion(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (String)this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("configversion")).get(String.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unloadNamespaceBundle(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle).path("unload")).put(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void splitNamespaceBundle(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle).path("split")).put(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBacklog(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("clearBacklog")).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBacklogForSubscription(String namespace, String subscription) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("clearBacklog").path(subscription)).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBundleBacklog(String namespace, String bundle) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle).path("clearBacklog")).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void clearNamespaceBundleBacklogForSubscription(String namespace, String bundle, String subscription) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle).path("clearBacklog").path(subscription)).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unsubscribeNamespace(String namespace, String subscription) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("unsubscribe").path(subscription)).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void unsubscribeNamespaceBundle(String namespace, String bundle, String subscription) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            this.request(this.namespaces.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path(bundle).path("unsubscribe").path(subscription)).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

