/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.Lookup;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.lookup.data.LookupData;
import com.yahoo.pulsar.common.naming.DestinationName;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.WebTarget;

public class LookupImpl
extends BaseResource
implements Lookup {
    private final WebTarget v2lookup;
    private final boolean useTls;

    public LookupImpl(WebTarget web, Authentication auth, boolean useTls) {
        super(auth);
        this.useTls = useTls;
        this.v2lookup = web.path("/lookup/v2");
    }

    private PulsarAdminException getLookupApiException(Exception e) {
        if (e instanceof ClientErrorException) {
            return new PulsarAdminException((ClientErrorException)e, e.getMessage());
        }
        return this.getApiException(e);
    }

    @Override
    public String lookupDestination(String destination) throws PulsarAdminException {
        try {
            DestinationName destName = DestinationName.get((String)destination);
            return this.doDestinationLookup(this.v2lookup.path("/destination"), destName);
        }
        catch (Exception e) {
            throw this.getLookupApiException(e);
        }
    }

    private String doDestinationLookup(WebTarget lookupResource, DestinationName destName) throws PulsarAdminException {
        LookupData lookupData = (LookupData)this.request(lookupResource.path(destName.getLookupName())).get(LookupData.class);
        if (this.useTls) {
            return lookupData.getBrokerUrlTls();
        }
        return lookupData.getBrokerUrl();
    }
}

