/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.Brokers;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import com.yahoo.pulsar.common.policies.data.NamespaceOwnershipStatus;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class BrokersImpl
extends BaseResource
implements Brokers {
    private final WebTarget brokers;

    public BrokersImpl(WebTarget web, Authentication auth) {
        super(auth);
        this.brokers = web.path("/brokers");
    }

    @Override
    public List<String> getActiveBrokers(String cluster) throws PulsarAdminException {
        try {
            return (List)this.request(this.brokers.path(cluster)).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, NamespaceOwnershipStatus> getOwnedNamespaces(String cluster, String brokerUrl) throws PulsarAdminException {
        try {
            return (Map)this.request(this.brokers.path(cluster).path(brokerUrl).path("ownedNamespaces")).get((GenericType)new GenericType<Map<String, NamespaceOwnershipStatus>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateDynamicConfiguration(String configName, String configValue) throws PulsarAdminException {
        try {
            this.request(this.brokers.path("/configuration/").path(configName).path(configValue)).post(Entity.json((Object)""), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, String> getAllDynamicConfigurations() throws PulsarAdminException {
        try {
            return (Map)this.request(this.brokers.path("/configuration/").path("values")).get((GenericType)new GenericType<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getDynamicConfigurationNames() throws PulsarAdminException {
        try {
            return (List)this.request(this.brokers.path("/configuration")).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

