/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.yahoo.pulsar.client.admin.BrokerStats;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.stats.AllocatorStats;
import javax.ws.rs.client.WebTarget;

public class BrokerStatsImpl
extends BaseResource
implements BrokerStats {
    private final WebTarget brokerStats;

    public BrokerStatsImpl(WebTarget target, Authentication auth) {
        super(auth);
        this.brokerStats = target.path("/broker-stats");
    }

    @Override
    public JsonArray getMetrics() throws PulsarAdminException {
        try {
            String json = (String)this.request(this.brokerStats.path("/metrics")).get(String.class);
            return (JsonArray)new Gson().fromJson(json, JsonArray.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public AllocatorStats getAllocatorStats(String allocatorName) throws PulsarAdminException {
        try {
            return (AllocatorStats)this.request(this.brokerStats.path("/allocator-stats").path(allocatorName)).get(AllocatorStats.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonArray getMBeans() throws PulsarAdminException {
        try {
            String json = (String)this.request(this.brokerStats.path("/mbeans")).get(String.class);
            return (JsonArray)new Gson().fromJson(json, JsonArray.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonObject getDestinations() throws PulsarAdminException {
        try {
            String json = (String)this.request(this.brokerStats.path("/destinations")).get(String.class);
            return (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public JsonObject getLoadReport() throws PulsarAdminException {
        try {
            String json = (String)this.request(this.brokerStats.path("/load-report")).get(String.class);
            return (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonObject getPendingBookieOpsStats() throws PulsarAdminException {
        try {
            String json = (String)this.request(this.brokerStats.path("/bookieops")).get(String.class);
            return (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public JsonObject getBrokerResourceAvailability(String property, String cluster, String namespace) throws PulsarAdminException {
        try {
            String json = (String)this.request(this.brokerStats.path("/broker-resource-availability").path(property).path(cluster).path(namespace)).get(String.class);
            return (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

