/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import java.io.Serializable;
import lombok.NonNull;

public final class QueryResult<T>
implements Serializable {
    private static final long serialVersionUID = -3748307200186480683L;
    @NonNull
    private final Iterable<T> data;
    private final Long pageTotals;

    QueryResult(@NonNull Iterable<T> data, Long pageTotals) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        this.pageTotals = pageTotals;
    }

    public static <T> QueryResultBuilder<T> builder() {
        return new QueryResultBuilder();
    }

    @NonNull
    public Iterable<T> getData() {
        return this.data;
    }

    public Long getPageTotals() {
        return this.pageTotals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResult)) {
            return false;
        }
        QueryResult other = (QueryResult)o;
        Long this$pageTotals = this.getPageTotals();
        Long other$pageTotals = other.getPageTotals();
        if (this$pageTotals == null ? other$pageTotals != null : !((Object)this$pageTotals).equals(other$pageTotals)) {
            return false;
        }
        Iterable<T> this$data = this.getData();
        Iterable<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pageTotals = this.getPageTotals();
        result = result * 59 + ($pageTotals == null ? 43 : ((Object)$pageTotals).hashCode());
        Iterable<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "QueryResult(data=" + this.getData() + ", pageTotals=" + this.getPageTotals() + ")";
    }

    public static class QueryResultBuilder<T> {
        private Iterable<T> data;
        private Long pageTotals;

        QueryResultBuilder() {
        }

        public QueryResultBuilder<T> data(@NonNull Iterable<T> data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        public QueryResultBuilder<T> pageTotals(Long pageTotals) {
            this.pageTotals = pageTotals;
            return this;
        }

        public QueryResult<T> build() {
            return new QueryResult<T>(this.data, this.pageTotals);
        }

        public String toString() {
            return "QueryResult.QueryResultBuilder(data=" + this.data + ", pageTotals=" + this.pageTotals + ")";
        }
    }
}

