/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AllocateDirect;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.WritableHandle;
import com.yahoo.memory.WritableMemory;

public final class WritableDirectHandle
implements WritableHandle {
    AllocateDirect direct;
    WritableMemory wMem;

    WritableDirectHandle(AllocateDirect allocatedDirect, WritableMemory wMem) {
        this.direct = allocatedDirect;
        this.wMem = wMem;
    }

    static WritableDirectHandle allocateDirect(ResourceState state) {
        AllocateDirect allocatedDirect = AllocateDirect.allocateDirect(state.getCapacity(), state);
        BaseWritableMemoryImpl wMem = BaseWritableMemoryImpl.newInstance(state, false);
        WritableDirectHandle handle = new WritableDirectHandle(allocatedDirect, wMem);
        return handle;
    }

    @Override
    public WritableMemory get() {
        return this.wMem;
    }

    @Override
    public void close() {
        if (this.direct != null) {
            this.direct.close();
            this.direct = null;
        }
    }
}

