/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableMemory;
import java.nio.ByteOrder;

final class WritableBufferImpl
extends BaseWritableBufferImpl {
    WritableBufferImpl(ResourceState state, boolean localReadOnly, BaseWritableMemoryImpl originMemory) {
        super(state, localReadOnly, originMemory);
        if (state.getResourceOrder() != ByteOrder.nativeOrder()) {
            throw new IllegalStateException("Expected native ordered state. This may be a bug in the Memory library.");
        }
    }

    @Override
    WritableBuffer writableDuplicateImpl(boolean localReadOnly) {
        this.checkValid();
        if (this.capacity == 0L) {
            return ZERO_SIZE_BUFFER;
        }
        WritableBufferImpl wBufImpl = new WritableBufferImpl(this.state, localReadOnly, this.originMemory);
        wBufImpl.setStartPositionEnd(this.getStart(), this.getPosition(), this.getEnd());
        return wBufImpl;
    }

    @Override
    WritableBuffer writableRegionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly) {
        this.checkValidAndBounds(offsetBytes, capacityBytes);
        if (capacityBytes == 0L) {
            return ZERO_SIZE_BUFFER;
        }
        ResourceState newState = this.state.copy();
        newState.putRegionOffset(newState.getRegionOffset() + offsetBytes);
        newState.putCapacity(capacityBytes);
        WritableBufferImpl wBufImpl = new WritableBufferImpl(newState, localReadOnly, this.originMemory);
        wBufImpl.setStartPositionEnd(0L, 0L, capacityBytes);
        return wBufImpl;
    }

    @Override
    public WritableMemory asWritableMemory() {
        if (this.localReadOnly) {
            throw new ReadOnlyException("This Buffer is Read-Only.");
        }
        return this.originMemory;
    }

    @Override
    public char getChar() {
        return this.getNativeOrderedChar();
    }

    @Override
    public char getChar(long offsetBytes) {
        return this.getNativeOrderedChar(offsetBytes);
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetChars, lengthChars, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + ((long)dstOffsetChars << 1), copyBytes);
    }

    @Override
    public double getDouble() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 8L);
        return UnsafeUtil.unsafe.getDouble(this.unsafeObj, this.cumBaseOffset + pos);
    }

    @Override
    public double getDouble(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return UnsafeUtil.unsafe.getDouble(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetDoubles, lengthDoubles, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + ((long)dstOffsetDoubles << 3), copyBytes);
    }

    @Override
    public float getFloat() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 4L);
        return UnsafeUtil.unsafe.getFloat(this.unsafeObj, this.cumBaseOffset + pos);
    }

    @Override
    public float getFloat(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return UnsafeUtil.unsafe.getFloat(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetFloats, lengthFloats, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + ((long)dstOffsetFloats << 2), copyBytes);
    }

    @Override
    public int getInt() {
        return this.getNativeOrderedInt();
    }

    @Override
    public int getInt(long offsetBytes) {
        return this.getNativeOrderedInt(offsetBytes);
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetInts, lengthInts, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + ((long)dstOffsetInts << 2), copyBytes);
    }

    @Override
    public long getLong() {
        return this.getNativeOrderedLong();
    }

    @Override
    public long getLong(long offsetBytes) {
        return this.getNativeOrderedLong(offsetBytes);
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetLongs, lengthLongs, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + ((long)dstOffsetLongs << 3), copyBytes);
    }

    @Override
    public short getShort() {
        return this.getNativeOrderedShort();
    }

    @Override
    public short getShort(long offsetBytes) {
        return this.getNativeOrderedShort(offsetBytes);
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetShorts, lengthShorts, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + ((long)dstOffsetShorts << 1), copyBytes);
    }

    @Override
    public void putChar(char value) {
        this.putNativeOrderedChar(value);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.putNativeOrderedChar(offsetBytes, value);
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetChars, lengthChars, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + ((long)srcOffsetChars << 1), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    @Override
    public void putDouble(double value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 8L);
        UnsafeUtil.unsafe.putDouble(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putDouble(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetDoubles, lengthDoubles, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + ((long)srcOffsetDoubles << 3), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    @Override
    public void putFloat(float value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 4L);
        UnsafeUtil.unsafe.putFloat(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putFloat(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetFloats, lengthFloats, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + ((long)srcOffsetFloats << 2), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    @Override
    public void putInt(int value) {
        this.putNativeOrderedInt(value);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.putNativeOrderedInt(offsetBytes, value);
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetInts, lengthInts, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + ((long)srcOffsetInts << 2), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    @Override
    public void putLong(long value) {
        this.putNativeOrderedLong(value);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.putNativeOrderedLong(offsetBytes, value);
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetLongs, lengthLongs, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + ((long)srcOffsetLongs << 3), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    @Override
    public void putShort(short value) {
        this.putNativeOrderedShort(value);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.putNativeOrderedShort(offsetBytes, value);
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetShorts, lengthShorts, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + ((long)srcOffsetShorts << 1), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }
}

