/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;

final class CompareAndCopy {
    static final int UNSAFE_COPY_THRESHOLD_BYTES = 0x100000;

    private CompareAndCopy() {
    }

    static int compare(ResourceState state1, long offsetBytes1, long lengthBytes1, ResourceState state2, long offsetBytes2, long lengthBytes2) {
        state1.checkValid();
        UnsafeUtil.checkBounds(offsetBytes1, lengthBytes1, state1.getCapacity());
        state2.checkValid();
        UnsafeUtil.checkBounds(offsetBytes2, lengthBytes2, state2.getCapacity());
        long cumOff1 = state1.getCumBaseOffset() + offsetBytes1;
        long cumOff2 = state2.getCumBaseOffset() + offsetBytes2;
        Object arr1 = state1.getUnsafeObject();
        Object arr2 = state2.getUnsafeObject();
        if (arr1 != arr2 || cumOff1 != cumOff2) {
            long lenBytes = Math.min(lengthBytes1, lengthBytes2);
            for (long i = 0L; i < lenBytes; ++i) {
                byte byte2;
                byte byte1 = UnsafeUtil.unsafe.getByte(arr1, cumOff1 + i);
                if (byte1 < (byte2 = UnsafeUtil.unsafe.getByte(arr2, cumOff2 + i))) {
                    return -1;
                }
                if (byte1 <= byte2) continue;
                return 1;
            }
        }
        return Long.compare(lengthBytes1, lengthBytes2);
    }

    static boolean equals(ResourceState state1, ResourceState state2) {
        long cap2;
        long cap1 = state1.getCapacity();
        return cap1 == (cap2 = state2.getCapacity()) && CompareAndCopy.equals(state1, 0L, state2, 0L, cap1);
    }

    static boolean equals(ResourceState state1, long offsetBytes1, ResourceState state2, long offsetBytes2, long lengthBytes) {
        state1.checkValid();
        UnsafeUtil.checkBounds(offsetBytes1, lengthBytes, state1.getCapacity());
        state2.checkValid();
        UnsafeUtil.checkBounds(offsetBytes2, lengthBytes, state2.getCapacity());
        long cumOff1 = state1.getCumBaseOffset() + offsetBytes1;
        long cumOff2 = state2.getCumBaseOffset() + offsetBytes2;
        Object arr1 = state1.getUnsafeObject();
        Object arr2 = state2.getUnsafeObject();
        if (arr1 == arr2 && cumOff1 == cumOff2) {
            return true;
        }
        while (lengthBytes >= 8L) {
            int i;
            int chunk = (int)Math.min(lengthBytes, 0x100000L);
            for (i = 0; i <= chunk - 8; i += 8) {
                long v2;
                long v1 = UnsafeUtil.unsafe.getLong(arr1, cumOff1 + (long)i);
                if (v1 == (v2 = UnsafeUtil.unsafe.getLong(arr2, cumOff2 + (long)i))) continue;
                return false;
            }
            lengthBytes -= (long)i;
            cumOff1 += (long)i;
            cumOff2 += (long)i;
        }
        return lengthBytes == 0L || CompareAndCopy.equalsByBytes(arr1, cumOff1, arr2, cumOff2, (int)lengthBytes);
    }

    private static boolean equalsByBytes(Object arr1, long cumOff1, Object arr2, long cumOff2, int lenBytes) {
        for (int i = 0; i < lenBytes; ++i) {
            byte v2;
            byte v1 = UnsafeUtil.unsafe.getByte(arr1, cumOff1 + (long)i);
            if (v1 == (v2 = UnsafeUtil.unsafe.getByte(arr2, cumOff2 + (long)i))) continue;
            return false;
        }
        return true;
    }

    static int hashCode(ResourceState state) {
        state.checkValid();
        long lenBytes = state.getCapacity();
        long cumOff = state.getCumBaseOffset();
        Object arr = state.getUnsafeObject();
        int result = 1;
        while (lenBytes >= 8L) {
            int i;
            int chunk = (int)Math.min(lenBytes, 0x100000L);
            for (i = 0; i <= chunk - 8; i += 8) {
                long v = UnsafeUtil.unsafe.getLong(arr, cumOff + (long)i);
                int vHash = (int)(v ^ v >>> 32);
                result = 31 * result + vHash;
            }
            lenBytes -= (long)i;
            cumOff += (long)i;
        }
        if (lenBytes == 0L) {
            return result;
        }
        long v = 0L;
        int i = 0;
        while ((long)i < lenBytes) {
            v |= ((long)UnsafeUtil.unsafe.getByte(arr, cumOff + (long)i) & 0xFFL) << (i << 3);
            ++i;
        }
        int vHash = (int)(v ^ v >>> 32);
        return 31 * result + vHash;
    }

    static void copy(ResourceState srcState, long srcOffsetBytes, ResourceState dstState, long dstOffsetBytes, long lengthBytes) {
        srcState.checkValid();
        UnsafeUtil.checkBounds(srcOffsetBytes, lengthBytes, srcState.getCapacity());
        dstState.checkValid();
        UnsafeUtil.checkBounds(dstOffsetBytes, lengthBytes, dstState.getCapacity());
        long srcAdd = srcState.getCumBaseOffset() + srcOffsetBytes;
        long dstAdd = dstState.getCumBaseOffset() + dstOffsetBytes;
        CompareAndCopy.copyMemory(srcState.getUnsafeObject(), srcAdd, dstState.getUnsafeObject(), dstAdd, lengthBytes);
    }

    static final void copyMemoryCheckingDifferentObject(Object srcUnsafeObj, long srcAdd, Object dstUnsafeObj, long dstAdd, long lengthBytes) {
        if (srcUnsafeObj == dstUnsafeObj) {
            throw new IllegalArgumentException("Not expecting to copy to/from array which is the underlying object of the memory at the same time");
        }
        CompareAndCopy.copyNonOverlappingMemoryWithChunking(srcUnsafeObj, srcAdd, dstUnsafeObj, dstAdd, lengthBytes);
    }

    private static void copyMemory(Object srcUnsafeObj, long srcAdd, Object dstUnsafeObj, long dstAdd, long lengthBytes) {
        if (srcUnsafeObj != dstUnsafeObj) {
            CompareAndCopy.copyNonOverlappingMemoryWithChunking(srcUnsafeObj, srcAdd, dstUnsafeObj, dstAdd, lengthBytes);
        } else {
            CompareAndCopy.copyMemoryOverlapAddressCheck(srcUnsafeObj, srcAdd, dstUnsafeObj, dstAdd, lengthBytes);
        }
    }

    private static void copyMemoryOverlapAddressCheck(Object srcUnsafeObj, long srcAdd, Object dstUnsafeObj, long dstAdd, long lengthBytes) {
        if (srcAdd + lengthBytes <= dstAdd || dstAdd + lengthBytes <= srcAdd) {
            CompareAndCopy.copyNonOverlappingMemoryWithChunking(srcUnsafeObj, srcAdd, dstUnsafeObj, dstAdd, lengthBytes);
            return;
        }
        if (srcAdd == dstAdd) {
            throw new IllegalArgumentException("Attempt to copy a block of memory exactly in-place, should be a bug");
        }
        UnsafeUtil.unsafe.copyMemory(srcUnsafeObj, srcAdd, dstUnsafeObj, dstAdd, lengthBytes);
    }

    private static void copyNonOverlappingMemoryWithChunking(Object srcUnsafeObj, long srcAdd, Object dstUnsafeObj, long dstAdd, long lengthBytes) {
        while (lengthBytes > 0L) {
            long chunk = Math.min(lengthBytes, 0x100000L);
            UnsafeUtil.unsafe.copyMemory(srcUnsafeObj, srcAdd, dstUnsafeObj, dstAdd, chunk);
            lengthBytes -= chunk;
            srcAdd += chunk;
            dstAdd += chunk;
        }
    }

    static void getNonNativeChars(Object unsafeObj, long cumBaseOffset, long offsetBytes, long copyBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        UnsafeUtil.checkBounds(dstOffsetChars, lengthChars, dstArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkChars = (int)(chunkBytes >> 1);
            CompareAndCopy.getCharArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetChars, chunkChars);
            cumulativeOffsetBytes += chunkBytes;
            dstOffsetChars += chunkChars;
            copyBytes -= chunkBytes;
            lengthChars -= chunkChars;
        }
        CompareAndCopy.getCharArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetChars, lengthChars);
    }

    private static void getCharArrayChunk(Object unsafeObj, long cumulativeOffsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        for (int i = 0; i < lengthChars; ++i) {
            dstArray[dstOffsetChars + i] = Character.reverseBytes(UnsafeUtil.unsafe.getChar(unsafeObj, cumulativeOffsetBytes + ((long)i << 1)));
        }
    }

    static void getNonNativeDoubles(Object unsafeObj, long cumBaseOffset, long offsetBytes, long copyBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        UnsafeUtil.checkBounds(dstOffsetDoubles, lengthDoubles, dstArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkDoubles = (int)(chunkBytes >> 3);
            CompareAndCopy.getDoubleArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetDoubles, chunkDoubles);
            cumulativeOffsetBytes += chunkBytes;
            dstOffsetDoubles += chunkDoubles;
            copyBytes -= chunkBytes;
            lengthDoubles -= chunkDoubles;
        }
        CompareAndCopy.getDoubleArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetDoubles, lengthDoubles);
    }

    private static void getDoubleArrayChunk(Object unsafeObj, long cumulativeOffsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        for (int i = 0; i < lengthDoubles; ++i) {
            dstArray[dstOffsetDoubles + i] = Double.longBitsToDouble(Long.reverseBytes(UnsafeUtil.unsafe.getLong(unsafeObj, cumulativeOffsetBytes + ((long)i << 3))));
        }
    }

    static void getNonNativeFloats(Object unsafeObj, long cumBaseOffset, long offsetBytes, long copyBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        UnsafeUtil.checkBounds(dstOffsetFloats, lengthFloats, dstArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkFloats = (int)(chunkBytes >> 2);
            CompareAndCopy.getFloatArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetFloats, chunkFloats);
            cumulativeOffsetBytes += chunkBytes;
            dstOffsetFloats += chunkFloats;
            copyBytes -= chunkBytes;
            lengthFloats -= chunkFloats;
        }
        CompareAndCopy.getFloatArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetFloats, lengthFloats);
    }

    private static void getFloatArrayChunk(Object unsafeObj, long cumulativeOffsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        for (int i = 0; i < lengthFloats; ++i) {
            dstArray[dstOffsetFloats + i] = Float.intBitsToFloat(Integer.reverseBytes(UnsafeUtil.unsafe.getInt(unsafeObj, cumulativeOffsetBytes + ((long)i << 2))));
        }
    }

    static void getNonNativeInts(Object unsafeObj, long cumBaseOffset, long offsetBytes, long copyBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        UnsafeUtil.checkBounds(dstOffsetInts, lengthInts, dstArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkInts = (int)(chunkBytes >> 2);
            CompareAndCopy.getIntArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetInts, chunkInts);
            cumulativeOffsetBytes += chunkBytes;
            dstOffsetInts += chunkInts;
            copyBytes -= chunkBytes;
            lengthInts -= chunkInts;
        }
        CompareAndCopy.getIntArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetInts, lengthInts);
    }

    private static void getIntArrayChunk(Object unsafeObj, long cumulativeOffsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        for (int i = 0; i < lengthInts; ++i) {
            dstArray[dstOffsetInts + i] = Integer.reverseBytes(UnsafeUtil.unsafe.getInt(unsafeObj, cumulativeOffsetBytes + ((long)i << 2)));
        }
    }

    static void getNonNativeLongs(Object unsafeObj, long cumBaseOffset, long offsetBytes, long copyBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        UnsafeUtil.checkBounds(dstOffsetLongs, lengthLongs, dstArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkLongs = (int)(chunkBytes >> 3);
            CompareAndCopy.getLongArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetLongs, chunkLongs);
            cumulativeOffsetBytes += chunkBytes;
            dstOffsetLongs += chunkLongs;
            copyBytes -= chunkBytes;
            lengthLongs -= chunkLongs;
        }
        CompareAndCopy.getLongArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetLongs, lengthLongs);
    }

    private static void getLongArrayChunk(Object unsafeObj, long cumulativeOffsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        for (int i = 0; i < lengthLongs; ++i) {
            dstArray[dstOffsetLongs + i] = Long.reverseBytes(UnsafeUtil.unsafe.getLong(unsafeObj, cumulativeOffsetBytes + ((long)i << 3)));
        }
    }

    static void getNonNativeShorts(Object unsafeObj, long cumBaseOffset, long offsetBytes, long copyBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        UnsafeUtil.checkBounds(dstOffsetShorts, lengthShorts, dstArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkShorts = (int)(chunkBytes >> 1);
            CompareAndCopy.getShortArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetShorts, chunkShorts);
            cumulativeOffsetBytes += chunkBytes;
            dstOffsetShorts += chunkShorts;
            copyBytes -= chunkBytes;
            lengthShorts -= chunkShorts;
        }
        CompareAndCopy.getShortArrayChunk(unsafeObj, cumulativeOffsetBytes, dstArray, dstOffsetShorts, lengthShorts);
    }

    private static void getShortArrayChunk(Object unsafeObj, long cumulativeOffsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        for (int i = 0; i < lengthShorts; ++i) {
            dstArray[dstOffsetShorts + i] = Short.reverseBytes(UnsafeUtil.unsafe.getShort(unsafeObj, cumulativeOffsetBytes + ((long)i << 1)));
        }
    }

    static void putNonNativeChars(char[] srcArray, int srcOffsetChars, int lengthChars, long copyBytes, Object unsafeObj, long cumBaseOffset, long offsetBytes) {
        UnsafeUtil.checkBounds(srcOffsetChars, lengthChars, srcArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkChars = (int)(chunkBytes >> 1);
            CompareAndCopy.putCharArrayChunk(srcArray, srcOffsetChars, chunkChars, unsafeObj, cumulativeOffsetBytes);
            cumulativeOffsetBytes += chunkBytes;
            srcOffsetChars += chunkChars;
            copyBytes -= chunkBytes;
            lengthChars -= chunkChars;
        }
        CompareAndCopy.putCharArrayChunk(srcArray, srcOffsetChars, lengthChars, unsafeObj, cumulativeOffsetBytes);
    }

    private static void putCharArrayChunk(char[] srcArray, int srcOffsetChars, int lengthChars, Object unsafeObj, long cumulativeOffsetBytes) {
        for (int i = 0; i < lengthChars; ++i) {
            UnsafeUtil.unsafe.putChar(unsafeObj, cumulativeOffsetBytes + ((long)i << 1), Character.reverseBytes(srcArray[srcOffsetChars + i]));
        }
    }

    static void putNonNativeDoubles(double[] srcArray, int srcOffsetDoubles, int lengthDoubles, long copyBytes, Object unsafeObj, long cumBaseOffset, long offsetBytes) {
        UnsafeUtil.checkBounds(srcOffsetDoubles, lengthDoubles, srcArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkDoubles = (int)(chunkBytes >> 3);
            CompareAndCopy.putDoubleArrayChunk(srcArray, srcOffsetDoubles, chunkDoubles, unsafeObj, cumulativeOffsetBytes);
            cumulativeOffsetBytes += chunkBytes;
            srcOffsetDoubles += chunkDoubles;
            copyBytes -= chunkBytes;
            lengthDoubles -= chunkDoubles;
        }
        CompareAndCopy.putDoubleArrayChunk(srcArray, srcOffsetDoubles, lengthDoubles, unsafeObj, cumulativeOffsetBytes);
    }

    private static void putDoubleArrayChunk(double[] srcArray, int srcOffsetDoubles, int lengthDoubles, Object unsafeObj, long cumulativeOffsetBytes) {
        for (int i = 0; i < lengthDoubles; ++i) {
            UnsafeUtil.unsafe.putLong(unsafeObj, cumulativeOffsetBytes + ((long)i << 3), Long.reverseBytes(Double.doubleToRawLongBits(srcArray[srcOffsetDoubles + i])));
        }
    }

    static void putNonNativeFloats(float[] srcArray, int srcOffsetFloats, int lengthFloats, long copyBytes, Object unsafeObj, long cumBaseOffset, long offsetBytes) {
        UnsafeUtil.checkBounds(srcOffsetFloats, lengthFloats, srcArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkFloats = (int)(chunkBytes >> 2);
            CompareAndCopy.putFloatArrayChunk(srcArray, srcOffsetFloats, chunkFloats, unsafeObj, cumulativeOffsetBytes);
            cumulativeOffsetBytes += chunkBytes;
            srcOffsetFloats += chunkFloats;
            copyBytes -= chunkBytes;
            lengthFloats -= chunkFloats;
        }
        CompareAndCopy.putFloatArrayChunk(srcArray, srcOffsetFloats, lengthFloats, unsafeObj, cumulativeOffsetBytes);
    }

    private static void putFloatArrayChunk(float[] srcArray, int srcOffsetFloats, int lengthFloats, Object unsafeObj, long cumulativeOffsetBytes) {
        for (int i = 0; i < lengthFloats; ++i) {
            UnsafeUtil.unsafe.putInt(unsafeObj, cumulativeOffsetBytes + ((long)i << 2), Integer.reverseBytes(Float.floatToRawIntBits(srcArray[srcOffsetFloats + i])));
        }
    }

    static void putNonNativeInts(int[] srcArray, int srcOffsetInts, int lengthInts, long copyBytes, Object unsafeObj, long cumBaseOffset, long offsetBytes) {
        UnsafeUtil.checkBounds(srcOffsetInts, lengthInts, srcArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkInts = (int)(chunkBytes >> 2);
            CompareAndCopy.putIntArrayChunk(srcArray, srcOffsetInts, chunkInts, unsafeObj, cumulativeOffsetBytes);
            cumulativeOffsetBytes += chunkBytes;
            srcOffsetInts += chunkInts;
            copyBytes -= chunkBytes;
            lengthInts -= chunkInts;
        }
        CompareAndCopy.putIntArrayChunk(srcArray, srcOffsetInts, lengthInts, unsafeObj, cumulativeOffsetBytes);
    }

    private static void putIntArrayChunk(int[] srcArray, int srcOffsetInts, int lengthInts, Object unsafeObj, long cumulativeOffsetBytes) {
        for (int i = 0; i < lengthInts; ++i) {
            UnsafeUtil.unsafe.putInt(unsafeObj, cumulativeOffsetBytes + ((long)i << 2), Integer.reverseBytes(srcArray[srcOffsetInts + i]));
        }
    }

    static void putNonNativeLongs(long[] srcArray, int srcOffsetLongs, int lengthLongs, long copyBytes, Object unsafeObj, long cumBaseOffset, long offsetBytes) {
        UnsafeUtil.checkBounds(srcOffsetLongs, lengthLongs, srcArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkLongs = (int)(chunkBytes >> 3);
            CompareAndCopy.putLongArrayChunk(srcArray, srcOffsetLongs, chunkLongs, unsafeObj, cumulativeOffsetBytes);
            cumulativeOffsetBytes += chunkBytes;
            srcOffsetLongs += chunkLongs;
            copyBytes -= chunkBytes;
            lengthLongs -= chunkLongs;
        }
        CompareAndCopy.putLongArrayChunk(srcArray, srcOffsetLongs, lengthLongs, unsafeObj, cumulativeOffsetBytes);
    }

    private static void putLongArrayChunk(long[] srcArray, int srcOffsetLongs, int lengthLongs, Object unsafeObj, long cumulativeOffsetBytes) {
        for (int i = 0; i < lengthLongs; ++i) {
            UnsafeUtil.unsafe.putLong(unsafeObj, cumulativeOffsetBytes + ((long)i << 3), Long.reverseBytes(srcArray[srcOffsetLongs + i]));
        }
    }

    static void putNonNativeShorts(short[] srcArray, int srcOffsetShorts, int lengthShorts, long copyBytes, Object unsafeObj, long cumBaseOffset, long offsetBytes) {
        UnsafeUtil.checkBounds(srcOffsetShorts, lengthShorts, srcArray.length);
        long cumulativeOffsetBytes = cumBaseOffset + offsetBytes;
        while (copyBytes > 0x100000L) {
            long chunkBytes = Math.min(copyBytes, 0x100000L);
            int chunkShorts = (int)(chunkBytes >> 1);
            CompareAndCopy.putShortArrayChunk(srcArray, srcOffsetShorts, chunkShorts, unsafeObj, cumulativeOffsetBytes);
            cumulativeOffsetBytes += chunkBytes;
            srcOffsetShorts += chunkShorts;
            copyBytes -= chunkBytes;
            lengthShorts -= chunkShorts;
        }
        CompareAndCopy.putShortArrayChunk(srcArray, srcOffsetShorts, lengthShorts, unsafeObj, cumulativeOffsetBytes);
    }

    private static void putShortArrayChunk(short[] srcArray, int srcOffsetShorts, int lengthShorts, Object unsafeObj, long cumulativeOffsetBytes) {
        for (int i = 0; i < lengthShorts; ++i) {
            UnsafeUtil.unsafe.putShort(unsafeObj, cumulativeOffsetBytes + ((long)i << 1), Short.reverseBytes(srcArray[srcOffsetShorts + i]));
        }
    }
}

