/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AccessByteBuffer;
import com.yahoo.memory.Map;
import com.yahoo.memory.NioBits;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

class AllocateDirectMap
implements Map {
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final Method FILE_CHANNEL_IMPL_MAP0_METHOD;
    private static final Method FILE_CHANNEL_IMPL_UNMAP0_METHOD;
    private static final Method MAPPED_BYTE_BUFFER_LOAD0_METHOD;
    private static final Method MAPPED_BYTE_BUFFER_ISLOADED0_METHOD;
    static final Method MAPPED_BYTE_BUFFER_FORCE0_METHOD;
    final ResourceState state;
    final Cleaner cleaner;
    final RandomAccessFile raf;

    AllocateDirectMap(ResourceState state, File file, long fileOffset) {
        this.state = state;
        this.raf = AllocateDirectMap.mapper(state, file, fileOffset);
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Deallocator(state, this.raf));
        ResourceState.currentDirectMemoryMapAllocations_.incrementAndGet();
        ResourceState.currentDirectMemoryMapAllocated_.addAndGet(state.getCapacity());
    }

    static AllocateDirectMap map(ResourceState state, File file, long fileOffset) {
        return new AllocateDirectMap(state, file, fileOffset);
    }

    @Override
    public void load() {
        this.madvise();
        int ps = NioBits.pageSize();
        int count = NioBits.pageCount(this.state.getCapacity());
        long nativeBaseOffset = this.state.getNativeBaseOffset();
        for (int i = 0; i < count; ++i) {
            UnsafeUtil.unsafe.getByte(nativeBaseOffset);
            nativeBaseOffset += (long)ps;
        }
    }

    @Override
    public boolean isLoaded() {
        try {
            long capacity = this.state.getCapacity();
            int pageCount = NioBits.pageCount(capacity);
            return (Boolean)MAPPED_BYTE_BUFFER_ISLOADED0_METHOD.invoke((Object)AccessByteBuffer.ZERO_DIRECT_BUFFER, this.state.getNativeBaseOffset(), capacity, pageCount);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    @Override
    public void close() {
        if (this.state.isValid()) {
            ResourceState.currentDirectMemoryMapAllocations_.decrementAndGet();
            ResourceState.currentDirectMemoryMapAllocated_.addAndGet(-this.state.getCapacity());
        }
        this.cleaner.clean();
    }

    void madvise() {
        try {
            MAPPED_BYTE_BUFFER_LOAD0_METHOD.invoke((Object)AccessByteBuffer.ZERO_DIRECT_BUFFER, this.state.getNativeBaseOffset(), this.state.getCapacity());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    static final RandomAccessFile mapper(ResourceState state, File file, long fileOffset) {
        RandomAccessFile raf;
        long capacity = state.getCapacity();
        boolean readOnlyFile = state.isResourceReadOnly();
        String mode = readOnlyFile ? "r" : "rw";
        try {
            raf = new RandomAccessFile(file, mode);
            if (fileOffset + capacity > raf.length()) {
                if (readOnlyFile) {
                    throw new IllegalStateException("File is shorter than the region that is requested to be mapped: file length=" + raf.length() + ", mapping offset=" + fileOffset + ", mapping size=" + capacity);
                }
                raf.setLength(fileOffset + capacity);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FileChannel fc = raf.getChannel();
        int mapMode = readOnlyFile ? 0 : 1;
        long nativeBaseOffset = AllocateDirectMap.map(fc, mapMode, fileOffset, capacity);
        state.putNativeBaseOffset(nativeBaseOffset);
        return raf;
    }

    private static final long map(FileChannel fileChannel, int mode, long position, long lengthBytes) {
        int pagePosition = (int)(position % (long)UnsafeUtil.unsafe.pageSize());
        long mapPosition = position - (long)pagePosition;
        long mapSize = lengthBytes + (long)pagePosition;
        try {
            long nativeBaseOffset = (Long)FILE_CHANNEL_IMPL_MAP0_METHOD.invoke((Object)fileChannel, mode, mapPosition, mapSize);
            return nativeBaseOffset;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception while mapping", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Exception while mapping", e);
        }
    }

    static final boolean isFileReadOnly(File file) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return !file.canWrite();
        }
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        PosixFileAttributes attributes = null;
        try {
            attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (attributes == null) {
            return false;
        }
        Set<PosixFilePermission> permissions = attributes.permissions();
        int bits = 0;
        bits |= permissions.contains((Object)PosixFilePermission.OWNER_READ) ? 256 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OWNER_WRITE) ? 128 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) ? 64 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.GROUP_READ) ? 32 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.GROUP_WRITE) ? 16 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) ? 8 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OTHERS_READ) ? 4 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OTHERS_WRITE) ? 2 : 0;
        return ((bits |= permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE) ? 1 : 0) & 0x13F) == 292;
    }

    static {
        try {
            FILE_CHANNEL_IMPL_MAP0_METHOD = FileChannelImpl.class.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            FILE_CHANNEL_IMPL_MAP0_METHOD.setAccessible(true);
            FILE_CHANNEL_IMPL_UNMAP0_METHOD = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            FILE_CHANNEL_IMPL_UNMAP0_METHOD.setAccessible(true);
            MAPPED_BYTE_BUFFER_LOAD0_METHOD = MappedByteBuffer.class.getDeclaredMethod("load0", Long.TYPE, Long.TYPE);
            MAPPED_BYTE_BUFFER_LOAD0_METHOD.setAccessible(true);
            MAPPED_BYTE_BUFFER_ISLOADED0_METHOD = MappedByteBuffer.class.getDeclaredMethod("isLoaded0", Long.TYPE, Long.TYPE, Integer.TYPE);
            MAPPED_BYTE_BUFFER_ISLOADED0_METHOD.setAccessible(true);
            MAPPED_BYTE_BUFFER_FORCE0_METHOD = MappedByteBuffer.class.getDeclaredMethod("force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
            MAPPED_BYTE_BUFFER_FORCE0_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not reflect static methods: " + e);
        }
    }

    private static final class Deallocator
    implements Runnable {
        private final RandomAccessFile myRaf;
        private final FileChannel myFc;
        private long actualNativeBaseOffset;
        private final long myCapacity;
        private final ResourceState parentStateRef;

        private Deallocator(ResourceState state, RandomAccessFile raf) {
            this.myRaf = raf;
            assert (this.myRaf != null);
            this.myFc = this.myRaf.getChannel();
            this.actualNativeBaseOffset = state.getNativeBaseOffset();
            assert (this.actualNativeBaseOffset != 0L);
            this.myCapacity = state.getCapacity();
            assert (this.myCapacity != 0L);
            this.parentStateRef = state;
        }

        @Override
        public void run() {
            if (this.myFc != null) {
                this.unmap();
            }
            this.actualNativeBaseOffset = 0L;
            this.parentStateRef.setInvalid();
        }

        private void unmap() throws RuntimeException {
            try {
                FILE_CHANNEL_IMPL_UNMAP0_METHOD.invoke((Object)this.myFc, this.actualNativeBaseOffset, this.myCapacity);
                this.myRaf.close();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Encountered %s exception while freeing memory", e.getClass()));
            }
        }
    }
}

