/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

final class AccessByteBuffer {
    static final ByteBuffer ZERO_DIRECT_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long NIO_BUFFER_ADDRESS_FIELD_OFFSET = UnsafeUtil.getFieldOffset(Buffer.class, "address");
    private static final long NIO_BUFFER_CAPACITY_FIELD_OFFSET = UnsafeUtil.getFieldOffset(Buffer.class, "capacity");
    private static final long BYTE_BUFFER_HB_FIELD_OFFSET = UnsafeUtil.getFieldOffset(ByteBuffer.class, "hb");
    private static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET = UnsafeUtil.getFieldOffset(ByteBuffer.class, "offset");

    private AccessByteBuffer() {
    }

    static void wrap(ResourceState state) {
        ByteBuffer byteBuf = state.getByteBuffer();
        state.putCapacity(byteBuf.capacity());
        boolean readOnlyBB = state.isResourceReadOnly();
        boolean direct = byteBuf.isDirect();
        if (readOnlyBB) {
            if (direct) {
                state.putNativeBaseOffset(((DirectBuffer)((Object)byteBuf)).address());
                return;
            }
            long regionOffset = UnsafeUtil.unsafe.getInt(byteBuf, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
            Object unsafeObj = UnsafeUtil.unsafe.getObject(byteBuf, BYTE_BUFFER_HB_FIELD_OFFSET);
            state.putUnsafeObject(unsafeObj);
            state.putRegionOffset(regionOffset);
            return;
        }
        if (direct) {
            state.putNativeBaseOffset(((DirectBuffer)((Object)byteBuf)).address());
            return;
        }
        state.putUnsafeObject(byteBuf.array());
        state.putRegionOffset(byteBuf.arrayOffset() * 1);
    }

    static ByteBuffer getDummyDirectByteBuffer(long address, int capacity) {
        ByteBuffer buf = ZERO_DIRECT_BUFFER.duplicate();
        UnsafeUtil.unsafe.putLong(buf, NIO_BUFFER_ADDRESS_FIELD_OFFSET, address);
        UnsafeUtil.unsafe.putInt(buf, NIO_BUFFER_CAPACITY_FIELD_OFFSET, capacity);
        buf.limit(capacity);
        return buf;
    }
}

