/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseBuffer;
import com.yahoo.memory.DefaultMemoryManager;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.StepBoolean;
import com.yahoo.memory.WritableDirectHandle;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

final class ResourceState {
    private static final ByteOrder nativeOrder_ = ByteOrder.nativeOrder();
    static AtomicLong currentDirectMemoryAllocations_ = new AtomicLong();
    static AtomicLong currentDirectMemoryAllocated_ = new AtomicLong();
    static AtomicLong currentDirectMemoryMapAllocations_ = new AtomicLong();
    static AtomicLong currentDirectMemoryMapAllocated_ = new AtomicLong();
    private long nativeBaseOffset_;
    private Object unsafeObj_;
    private long unsafeObjHeader_;
    private long capacity_;
    private long cumBaseOffset_;
    private MemoryRequestServer memReqSvr_ = DefaultMemoryManager.getInstance();
    private WritableDirectHandle handle_;
    private StepBoolean resourceIsReadOnly_ = new StepBoolean(false);
    private StepBoolean valid_ = new StepBoolean(true);
    private long regionOffset_;
    private ByteBuffer byteBuf_;
    private File file_;
    private long fileOffset_;
    private RandomAccessFile raf_;
    private MappedByteBuffer mbb_;
    private BaseBuffer baseBuf_;
    private ByteOrder resourceOrder_ = nativeOrder_;
    private boolean swapBytes_;

    ResourceState() {
    }

    ResourceState(Object obj, Prim prim, long arrLen) {
        this.unsafeObj_ = obj;
        this.unsafeObjHeader_ = prim.off();
        if (arrLen < 0L) {
            throw new IllegalArgumentException("Array length cannot be < 0");
        }
        this.capacity_ = arrLen << prim.shift();
        this.compute();
    }

    ResourceState copy() {
        ResourceState out = new ResourceState();
        out.nativeBaseOffset_ = this.nativeBaseOffset_;
        out.unsafeObj_ = this.unsafeObj_;
        out.unsafeObjHeader_ = this.unsafeObjHeader_;
        out.capacity_ = this.capacity_;
        out.memReqSvr_ = this.memReqSvr_;
        out.resourceIsReadOnly_ = this.resourceIsReadOnly_;
        out.valid_ = this.valid_;
        out.regionOffset_ = this.regionOffset_;
        out.byteBuf_ = this.byteBuf_;
        out.file_ = this.file_;
        out.fileOffset_ = this.fileOffset_;
        out.raf_ = this.raf_;
        out.mbb_ = this.mbb_;
        out.resourceOrder_ = this.resourceOrder_;
        out.swapBytes_ = this.swapBytes_;
        out.compute();
        out.baseBuf_ = new BaseBuffer(out);
        return out;
    }

    private void compute() {
        this.cumBaseOffset_ = this.regionOffset_ + (this.unsafeObj_ == null ? this.nativeBaseOffset_ : this.unsafeObjHeader_);
    }

    long getNativeBaseOffset() {
        return this.nativeBaseOffset_;
    }

    void putNativeBaseOffset(long nativeBaseOffset) {
        this.nativeBaseOffset_ = nativeBaseOffset;
        this.compute();
    }

    Object getUnsafeObject() {
        return this.unsafeObj_;
    }

    void putUnsafeObject(Object unsafeObj) {
        if (unsafeObj == null) {
            throw new IllegalArgumentException("Object may not be assigned null");
        }
        this.unsafeObj_ = unsafeObj;
        this.compute();
    }

    long getUnsafeObjectHeader() {
        return this.unsafeObjHeader_;
    }

    void putUnsafeObjectHeader(long unsafeObjHeader) {
        if (unsafeObjHeader < 0L) {
            throw new IllegalArgumentException("Object Header may not be negative.");
        }
        this.unsafeObjHeader_ = unsafeObjHeader;
        this.compute();
    }

    long getCapacity() {
        return this.capacity_;
    }

    void putCapacity(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity may not be negative.");
        }
        this.capacity_ = capacity;
    }

    long getCumBaseOffset() {
        return this.cumBaseOffset_;
    }

    MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr_;
    }

    void setMemoryRequestServer(MemoryRequestServer memReqSvr) {
        this.memReqSvr_ = memReqSvr;
    }

    WritableDirectHandle getHandle() {
        return this.handle_;
    }

    void setHandle(WritableDirectHandle handler) {
        this.handle_ = handler;
    }

    boolean isResourceReadOnly() {
        return this.resourceIsReadOnly_.get();
    }

    void setResourceReadOnly() {
        this.resourceIsReadOnly_.change();
    }

    boolean isValid() {
        return this.valid_.get();
    }

    void setInvalid() {
        this.valid_.change();
    }

    boolean isDirect() {
        return this.nativeBaseOffset_ > 0L;
    }

    boolean isSameResource(ResourceState that) {
        if (this == that) {
            return true;
        }
        return this.getCumBaseOffset() == that.getCumBaseOffset() && this.getCapacity() == that.getCapacity() && this.getUnsafeObject() == that.getUnsafeObject() && this.getByteBuffer() == that.getByteBuffer();
    }

    long getRegionOffset() {
        return this.regionOffset_;
    }

    void putRegionOffset(long regionOffset) {
        if (regionOffset < 0L) {
            throw new IllegalArgumentException("Region Offset may not be negative.");
        }
        this.regionOffset_ = regionOffset;
        this.compute();
    }

    ByteBuffer getByteBuffer() {
        return this.byteBuf_;
    }

    void putByteBuffer(ByteBuffer byteBuf) {
        if (byteBuf == null) {
            throw new IllegalArgumentException("ByteBuffer may not be assigned null");
        }
        this.byteBuf_ = byteBuf;
        this.resourceOrder_ = this.byteBuf_.order();
        this.swapBytes_ = this.resourceOrder_ != nativeOrder_;
    }

    File getFile() {
        return this.file_;
    }

    void putFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File may not be assigned null");
        }
        this.file_ = file;
    }

    long getFileOffset() {
        return this.fileOffset_;
    }

    void putFileOffset(long fileOffset) {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("File Offset may not be negative.");
        }
        this.fileOffset_ = fileOffset;
    }

    RandomAccessFile getRandomAccessFile() {
        return this.raf_;
    }

    void putRandomAccessFile(RandomAccessFile raf) {
        if (raf == null) {
            throw new IllegalArgumentException("RandomAccessFile may not be assigned null");
        }
        this.raf_ = raf;
    }

    MappedByteBuffer getMappedByteBuffer() {
        return this.mbb_;
    }

    void putMappedByteBuffer(MappedByteBuffer mbb) {
        if (mbb == null) {
            throw new IllegalArgumentException("MappedByteBuffer may not be assigned null");
        }
        this.mbb_ = mbb;
    }

    BaseBuffer getBaseBuffer() {
        return this.baseBuf_;
    }

    void putBaseBuffer(BaseBuffer baseBuf) {
        this.baseBuf_ = baseBuf;
    }

    ByteOrder order() {
        return this.resourceOrder_;
    }

    void order(ByteOrder resourceOrder) {
        this.resourceOrder_ = resourceOrder;
        this.swapBytes_ = this.resourceOrder_ != nativeOrder_;
    }

    boolean isSwapBytes() {
        return this.swapBytes_;
    }
}

