/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AllocateDirectMap;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.WritableMap;
import java.io.FileDescriptor;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;

final class AllocateDirectWritableMap
extends AllocateDirectMap
implements WritableMap {
    private AllocateDirectWritableMap(ResourceState state) {
        super(state);
    }

    static AllocateDirectWritableMap map(ResourceState state) throws Exception {
        if (AllocateDirectWritableMap.isFileReadOnly(state.getFile())) {
            throw new ReadOnlyException("File is read-only.");
        }
        return new AllocateDirectWritableMap(AllocateDirectMap.mapper(state));
    }

    @Override
    public void force() {
        try {
            Method method = MappedByteBuffer.class.getDeclaredMethod("force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.state.getMappedByteBuffer(), this.state.getRandomAccessFile().getFD(), this.state.getNativeBaseOffset(), this.state.getCapacity());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception in force", e.getClass()));
        }
    }
}

