/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Buffer;
import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableBufferImpl;
import com.yahoo.memory.WritableDirectHandle;
import com.yahoo.memory.WritableMemory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class WritableMemoryImpl
extends WritableMemory {
    final ResourceState state;
    final Object unsafeObj;
    final long unsafeObjHeader;
    final long capacity;
    final long cumBaseOffset;
    static final WritableMemoryImpl MEMORY_ZERO_SIZE = new WritableMemoryImpl(new ResourceState(new byte[0], Prim.BYTE, 0L));

    WritableMemoryImpl(ResourceState state) {
        this.state = state;
        this.unsafeObj = state.getUnsafeObject();
        this.unsafeObjHeader = state.getUnsafeObjectHeader();
        this.capacity = state.getCapacity();
        this.cumBaseOffset = state.getCumBaseOffset();
    }

    @Override
    public Memory duplicate() {
        return this.region(0L, this.capacity);
    }

    @Override
    public WritableMemory writableDuplicate() {
        return this.writableRegion(0L, this.capacity);
    }

    @Override
    public Memory region(long offsetBytes, long capacityBytes) {
        this.checkValid();
        return this.writableRegion(offsetBytes, capacityBytes);
    }

    @Override
    public WritableMemory writableRegion(long offsetBytes, long capacityBytes) {
        this.checkValid();
        assert (offsetBytes + capacityBytes <= this.capacity) : "newOff + newCap: " + (offsetBytes + capacityBytes) + ", origCap: " + this.capacity;
        ResourceState newState = this.state.copy();
        newState.putRegionOffset(newState.getRegionOffset() + offsetBytes);
        newState.putCapacity(capacityBytes);
        return new WritableMemoryImpl(newState);
    }

    @Override
    public Buffer asBuffer() {
        return new WritableBufferImpl(this.state.copy());
    }

    @Override
    public WritableBuffer asWritableBuffer() {
        return new WritableBufferImpl(this.state.copy());
    }

    @Override
    public boolean getBoolean(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getBoolean(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public byte getByte(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getByte(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getByteArray(long offsetBytes, byte[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (dstOffset << 0), copyBytes);
    }

    @Override
    public char getChar(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getChar(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public double getDouble(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getDouble(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public float getFloat(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getFloat(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public int getInt(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (dstOffset << 2), copyBytes);
    }

    @Override
    public long getLong(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (dstOffset << 3), copyBytes);
    }

    @Override
    public short getShort(long offsetBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.getShort(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, dstArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (dstOffset << 1), copyBytes);
    }

    @Override
    public int compareTo(long thisOffsetBytes, long thisLengthBytes, Memory that, long thatOffsetBytes, long thatLengthBytes) {
        this.checkValid();
        ((WritableMemoryImpl)that).checkValid();
        UnsafeUtil.assertBounds(thisOffsetBytes, thisLengthBytes, this.capacity);
        UnsafeUtil.assertBounds(thatOffsetBytes, thatLengthBytes, that.getCapacity());
        long thisAdd = this.getCumulativeOffset(thisOffsetBytes);
        long thatAdd = that.getCumulativeOffset(thatOffsetBytes);
        Object thisObj = this.isDirect() ? null : this.unsafeObj;
        Object thatObj = that.isDirect() ? null : ((WritableMemory)that).getArray();
        long lenBytes = Math.min(thisLengthBytes, thatLengthBytes);
        for (long i = 0L; i < lenBytes; ++i) {
            byte thatByte;
            byte thisByte = UnsafeUtil.unsafe.getByte(thisObj, thisAdd + i);
            if (thisByte < (thatByte = UnsafeUtil.unsafe.getByte(thatObj, thatAdd + i))) {
                return -1;
            }
            if (thisByte <= thatByte) continue;
            return 1;
        }
        if (thisLengthBytes < thatLengthBytes) {
            return -1;
        }
        if (thisLengthBytes > thatLengthBytes) {
            return 1;
        }
        return 0;
    }

    @Override
    public void copyTo(long srcOffsetBytes, WritableMemory destination, long dstOffsetBytes, long lengthBytes) {
        this.checkValid();
        UnsafeUtil.assertBounds(srcOffsetBytes, lengthBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffsetBytes, lengthBytes, destination.getCapacity());
        assert (this != destination || UnsafeUtil.checkOverlap(srcOffsetBytes, dstOffsetBytes, lengthBytes)) : "Region Overlap";
        long srcAdd = this.getCumulativeOffset(srcOffsetBytes);
        long dstAdd = destination.getCumulativeOffset(dstOffsetBytes);
        Object srcParent = this.isDirect() ? null : this.unsafeObj;
        Object dstParent = destination.isDirect() ? null : destination.getArray();
        long lenBytes = lengthBytes;
        while (lenBytes > 0L) {
            long chunkBytes = lenBytes > 0x100000L ? 0x100000L : lenBytes;
            UnsafeUtil.unsafe.copyMemory(srcParent, srcAdd, dstParent, dstAdd, lenBytes);
            lenBytes -= chunkBytes;
            srcAdd += chunkBytes;
            dstAdd += chunkBytes;
        }
    }

    @Override
    public long getCapacity() {
        this.checkValid();
        return this.capacity;
    }

    @Override
    public long getCumulativeOffset(long offsetBytes) {
        this.checkValid();
        return this.cumBaseOffset + offsetBytes;
    }

    @Override
    public long getRegionOffset(long offsetBytes) {
        this.checkValid();
        return this.state.getRegionOffset() + offsetBytes;
    }

    @Override
    public ByteOrder getResourceOrder() {
        this.checkValid();
        return this.state.order();
    }

    @Override
    public boolean hasArray() {
        this.checkValid();
        return this.unsafeObj != null;
    }

    @Override
    public boolean hasByteBuffer() {
        this.checkValid();
        return this.state.getByteBuffer() != null;
    }

    @Override
    public boolean isDirect() {
        this.checkValid();
        return this.state.isDirect();
    }

    @Override
    public boolean isResourceReadOnly() {
        this.checkValid();
        return this.state.isResourceReadOnly();
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.state.isSameResource(that.getResourceState());
    }

    @Override
    public boolean isValid() {
        return this.state.isValid();
    }

    @Override
    public boolean swapBytes() {
        return this.state.isSwapBytes();
    }

    @Override
    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        this.checkValid();
        String klass = this.getClass().getSimpleName();
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(klass).append(" SUMMARY ###").append(UnsafeUtil.LS);
        sb.append("Header Comment      : ").append(header).append(UnsafeUtil.LS);
        sb.append("Call Params         : ").append(call);
        return Memory.toHex(sb.toString(), offsetBytes, lengthBytes, this.state);
    }

    @Override
    public void putBoolean(long offsetBytes, boolean value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putBoolean(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (srcOffset << 0), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putByte(long offsetBytes, byte value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putByteArray(long offsetBytes, byte[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (srcOffset << 0), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putChar(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (srcOffset << 1), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putDouble(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (srcOffset << 3), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putFloat(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (srcOffset << 2), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (srcOffset << 2), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (srcOffset << 3), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putShort(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(offsetBytes, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (srcOffset << 1), this.unsafeObj, this.cumBaseOffset + offsetBytes, copyBytes);
    }

    @Override
    public long getAndAddLong(long offsetBytes, long delta) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacity);
        long add = this.cumBaseOffset + offsetBytes;
        return UnsafeUtil.compatibilityMethods.getAndAddLong(this.unsafeObj, add, delta) + delta;
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacity);
        long add = this.cumBaseOffset + offsetBytes;
        return UnsafeUtil.compatibilityMethods.getAndSetLong(this.unsafeObj, add, newValue);
    }

    @Override
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacity);
        return UnsafeUtil.unsafe.compareAndSwapLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, expect, update);
    }

    @Override
    public Object getArray() {
        this.checkValid();
        return this.unsafeObj;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.checkValid();
        return this.state.getByteBuffer();
    }

    @Override
    public void clear() {
        this.fill(0L, this.capacity, (byte)0);
    }

    @Override
    public void clear(long offsetBytes, long lengthBytes) {
        this.checkValid();
        this.fill(offsetBytes, lengthBytes, (byte)0);
    }

    @Override
    public void clearBits(long offsetBytes, byte bitMask) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacity);
        long cumBaseOff = this.cumBaseOffset + offsetBytes;
        int value = UnsafeUtil.unsafe.getByte(this.unsafeObj, cumBaseOff) & 0xFF;
        UnsafeUtil.unsafe.putByte(this.unsafeObj, cumBaseOff, (byte)(value &= ~bitMask));
    }

    @Override
    public void fill(byte value) {
        this.checkValid();
        this.fill(0L, this.capacity, value);
    }

    @Override
    public void fill(long offsetBytes, long lengthBytes, byte value) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacity);
        UnsafeUtil.unsafe.setMemory(this.unsafeObj, this.cumBaseOffset + offsetBytes, lengthBytes, value);
    }

    @Override
    public void setBits(long offsetBytes, byte bitMask) {
        this.checkValid();
        UnsafeUtil.assertBounds(offsetBytes, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacity);
        long myOffset = this.cumBaseOffset + offsetBytes;
        byte value = UnsafeUtil.unsafe.getByte(this.unsafeObj, myOffset);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, myOffset, (byte)(value | bitMask));
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        this.checkValid();
        return this.state.getMemoryRequestServer();
    }

    @Override
    public void setMemoryRequest(MemoryRequestServer memReqSvr) {
        this.state.setMemoryRequestServer(memReqSvr);
    }

    @Override
    public WritableDirectHandle getHandle() {
        return this.state.getHandle();
    }

    @Override
    public void setHandle(WritableDirectHandle handle) {
        this.state.setHandle(handle);
    }

    private final void checkValid() {
        assert (this.state.isValid()) : "Memory not valid.";
    }

    @Override
    ResourceState getResourceState() {
        return this.state;
    }
}

