/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

final class AccessByteBuffer {
    private AccessByteBuffer() {
    }

    static ResourceState wrap(ResourceState state) {
        ByteBuffer byteBuf = state.getByteBuffer();
        state.putCapacity(byteBuf.capacity());
        boolean readOnlyBB = byteBuf.isReadOnly();
        boolean direct = byteBuf.isDirect();
        if (readOnlyBB) {
            Object unsafeObj;
            long regionOffset;
            state.setResourceReadOnly();
            if (direct) {
                state.putNativeBaseOffset(((DirectBuffer)((Object)byteBuf)).address());
                return state;
            }
            try {
                Field field = ByteBuffer.class.getDeclaredField("offset");
                field.setAccessible(true);
                regionOffset = ((Integer)field.get(byteBuf)).longValue() * (long)UnsafeUtil.ARRAY_BYTE_INDEX_SCALE;
                field = ByteBuffer.class.getDeclaredField("hb");
                field.setAccessible(true);
                unsafeObj = field.get(byteBuf);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Could not get offset/byteArray from OnHeap ByteBuffer instance: " + e.getClass());
            }
            state.putUnsafeObjectHeader(UnsafeUtil.ARRAY_BYTE_BASE_OFFSET);
            state.putUnsafeObject(unsafeObj);
            state.putRegionOffset(regionOffset);
            return state;
        }
        if (direct) {
            state.putNativeBaseOffset(((DirectBuffer)((Object)byteBuf)).address());
            return state;
        }
        state.putUnsafeObject(byteBuf.array());
        state.putUnsafeObjectHeader(UnsafeUtil.ARRAY_BYTE_BASE_OFFSET);
        state.putRegionOffset(byteBuf.arrayOffset() * UnsafeUtil.ARRAY_BYTE_INDEX_SCALE);
        return state;
    }
}

