/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder.core;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapBuilderFinder;
import org.reficio.ws.builder.core.SoapBuilderImpl;
import org.reficio.ws.legacy.SoapLegacyFacade;

public final class Wsdl {
    private final URL wsdlUrl;
    private final SoapLegacyFacade soapFacade;

    private Wsdl(URL wsdlUrl) {
        try {
            this.wsdlUrl = wsdlUrl;
            this.soapFacade = new SoapLegacyFacade(wsdlUrl);
        }
        catch (WSDLException e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public static Wsdl parse(URL wsdlUrl) {
        Preconditions.checkNotNull((Object)wsdlUrl, (Object)"URL of the WSDL cannot be null");
        return new Wsdl(wsdlUrl);
    }

    public static Wsdl parse(String wsdlUrl) {
        Preconditions.checkNotNull((Object)wsdlUrl, (Object)"URL of the WSDL cannot be null");
        try {
            return new Wsdl(new URL(wsdlUrl));
        }
        catch (MalformedURLException e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public List<QName> getBindings() {
        return this.soapFacade.getBindingNames();
    }

    public SoapBuilderFinder binding() {
        return new SoapBuilderFinderImpl();
    }

    public URL saveWsdl(File rootWsdl) {
        return this.soapFacade.saveWsdl(rootWsdl.getName(), rootWsdl.getParentFile());
    }

    public static URL saveWsdl(URL wsdlUrl, File rootWsdl) {
        return SoapLegacyFacade.saveWsdl((URL)wsdlUrl, (String)rootWsdl.getName(), (File)rootWsdl.getParentFile());
    }

    public void printBindings() {
        System.out.println(this.wsdlUrl);
        for (QName bindingName : this.soapFacade.getBindingNames()) {
            System.out.println("\t" + bindingName.toString());
        }
    }

    public SoapBuilder getBuilder(String bindingName) {
        return this.getBuilder(bindingName, SoapContext.DEFAULT);
    }

    public SoapBuilder getBuilder(String bindingName, SoapContext context) {
        Preconditions.checkNotNull((Object)bindingName, (Object)"BindingName cannot be null");
        return this.getBuilder(QName.valueOf(bindingName), context);
    }

    public SoapBuilder getBuilder(QName bindingName) {
        return this.getBuilder(bindingName, SoapContext.DEFAULT);
    }

    public SoapBuilder getBuilder(QName bindingName, SoapContext context) {
        Preconditions.checkNotNull((Object)bindingName, (Object)"BindingName cannot be null");
        Preconditions.checkNotNull((Object)context, (Object)"SoapContext cannot be null");
        Binding binding = this.soapFacade.getBindingByName(bindingName);
        return new SoapBuilderImpl(this.soapFacade, binding, context);
    }

    class SoapBuilderFinderImpl
    implements SoapBuilderFinder {
        private String namespaceURI;
        private String localPart;
        private String prefix;

        SoapBuilderFinderImpl() {
        }

        @Override
        public SoapBuilderFinder name(String name) {
            return this.name(QName.valueOf(name));
        }

        @Override
        public SoapBuilderFinder name(QName name) {
            this.namespaceURI = name.getNamespaceURI();
            this.localPart = name.getLocalPart();
            this.prefix = name.getPrefix();
            return this;
        }

        @Override
        public SoapBuilderFinder namespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
            return this;
        }

        @Override
        public SoapBuilderFinder localPart(String localPart) {
            this.localPart = localPart;
            return this;
        }

        @Override
        public SoapBuilderFinder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public SoapBuilder find() {
            this.validate();
            return Wsdl.this.getBuilder(this.getBindingName(), SoapContext.DEFAULT);
        }

        @Override
        public SoapBuilder find(SoapContext context) {
            this.validate();
            return Wsdl.this.getBuilder(this.getBindingName(), context);
        }

        private QName getBindingName() {
            ArrayList<QName> result = new ArrayList<QName>();
            for (QName bindingName : Wsdl.this.soapFacade.getBindingNames()) {
                if (!bindingName.getLocalPart().equals(this.localPart) || this.namespaceURI != null && !bindingName.getNamespaceURI().equals(this.namespaceURI) || this.prefix != null && !bindingName.getPrefix().equals(this.prefix)) continue;
                result.add(bindingName);
            }
            if (result.isEmpty()) {
                throw new SoapBuilderException("Binding not found");
            }
            if (result.size() > 1) {
                throw new SoapBuilderException("Found more than one binding " + result);
            }
            return (QName)result.iterator().next();
        }

        private void validate() {
            if (StringUtils.isBlank((CharSequence)this.localPart)) {
                throw new SoapBuilderException("Specify at least localPart of the binding's QName");
            }
        }
    }
}

