/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String string) {
        this.s = string;
    }

    @Override
    public final String toString() {
        boolean bl = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            bl = false;
            break;
        }
        if (bl) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    @Override
    public final boolean evalBoolean(VTDNav vTDNav) {
        return this.s.length() != 0;
    }

    @Override
    public final double evalNumber(VTDNav vTDNav) {
        try {
            double d = Double.parseDouble(this.s);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    @Override
    public final int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("LiteralExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNav vTDNav) {
        return this.s;
    }

    @Override
    public final void reset(VTDNav vTDNav) {
    }

    @Override
    public final boolean isNodeSet() {
        return false;
    }

    @Override
    public final boolean isNumerical() {
        return false;
    }

    @Override
    public final boolean isString() {
        return true;
    }

    @Override
    public final boolean isBoolean() {
        return false;
    }

    @Override
    public final boolean requireContextSize() {
        return false;
    }

    @Override
    public final void setContextSize(int n) {
    }

    @Override
    public final void setPosition(int n) {
    }

    @Override
    public final int adjust(int n) {
        return 0;
    }

    @Override
    public final boolean isFinal() {
        return true;
    }
}

