/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class NumExpr
extends Expr {
    public double dval;

    public NumExpr(double d) {
        this.dval = d;
    }

    @Override
    public String toString() {
        if (this.dval == (double)((long)this.dval)) {
            return "" + (long)this.dval;
        }
        return "" + this.dval;
    }

    public double eval() {
        return this.dval;
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        return this.dval != 0.0 && !Double.isNaN(this.dval);
    }

    @Override
    public double evalNumber(VTDNavHuge vTDNavHuge) {
        return this.dval;
    }

    @Override
    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("NumExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNavHuge vTDNavHuge) {
        if (this.dval == (double)((int)this.dval)) {
            return "" + (int)this.dval;
        }
        return "" + this.dval;
    }

    @Override
    public void reset(VTDNavHuge vTDNavHuge) {
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return false;
    }

    @Override
    public void setContextSize(int n) {
    }

    @Override
    public void setPosition(int n) {
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

