/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.parser;

public class XMLChar {
    private static final byte[] UNI_CHARS;
    public static final int XML_VALID = 1;
    public static final int XML_SPACE = 2;
    public static final int XML_NAME_START = 4;
    public static final int XML_NAME = 8;
    public static final int XML_PUBID = 16;
    public static final int XML_CONTENT = 32;
    public static final int XML_NCNAME_START = 64;
    public static final int XML_NCNAME = 128;

    public static char highSurrogate(int n) {
        return (char)((n >> 10) + 55232);
    }

    public static boolean isContentChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 0x20) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isHighSurrogate(int n) {
        return 55296 <= n && n <= 56319;
    }

    public static boolean isInvalidChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 1) == 0 || n >= 0x10FFFF;
    }

    public static boolean isLowSurrogate(int n) {
        return 56320 <= n && n <= 57343;
    }

    public static boolean isMarkupChar(int n) {
        return n == 60 || n == 38 || n == 37;
    }

    public static boolean isNameChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 8) != 0;
    }

    public static boolean isNameStartChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 4) != 0;
    }

    public static boolean isNCNameChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 0x80) != 0;
    }

    public static boolean isNCNameStartChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 0x40) != 0;
    }

    public static boolean isNmtoken(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (XMLChar.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPubidChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 0x10) != 0;
    }

    public static boolean isSpaceChar(int n) {
        return n <= 32 && (UNI_CHARS[n] & 2) != 0;
    }

    public static boolean isSupplementalChar(int n) {
        return n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isValidChar(int n) {
        return n < 65536 && (UNI_CHARS[n] & 1) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static char lowSurrogate(int n) {
        return (char)((n - 65536 & 0x3FF) + 56320);
    }

    public static int scalarValueSurrogate(char c, char c2) {
        return (c - 55296 << 10) + c2 - 9216;
    }

    static {
        int n;
        int n2;
        UNI_CHARS = new byte[65536];
        int[][] nArrayArray = new int[][]{{9, 10}, {13, 13}, {32, 55295}, {57344, 65533}};
        int[] nArray = new int[]{32, 9, 13, 10};
        int[] nArray2 = new int[]{45, 46};
        int[] nArray3 = new int[]{58, 95};
        int[] nArray4 = new int[]{10, 13, 32, 33, 35, 36, 37, 61, 95};
        int[][] nArrayArray2 = new int[][]{{39, 59}, {63, 90}, {97, 122}};
        int[][] nArrayArray3 = new int[][]{{65, 90}, {97, 122}, {192, 214}, {216, 246}, {248, 305}, {308, 318}, {321, 328}, {330, 382}, {384, 451}, {461, 496}, {500, 501}, {506, 535}, {592, 680}, {699, 705}, {904, 906}, {910, 929}, {931, 974}, {976, 982}, {994, 1011}, {1025, 1036}, {1038, 1103}, {1105, 1116}, {1118, 1153}, {1168, 1220}, {1223, 1224}, {1227, 1228}, {1232, 1259}, {1262, 1269}, {1272, 1273}, {1329, 1366}, {1377, 1414}, {1488, 1514}, {1520, 1522}, {1569, 1594}, {1601, 1610}, {1649, 1719}, {1722, 1726}, {1728, 1742}, {1744, 1747}, {1765, 1766}, {2309, 2361}, {2392, 2401}, {2437, 2444}, {2447, 2448}, {2451, 2472}, {2474, 2480}, {2486, 2489}, {2524, 2525}, {2527, 2529}, {2544, 2545}, {2565, 2570}, {2575, 2576}, {2579, 2600}, {2602, 2608}, {2610, 2611}, {2613, 2614}, {2616, 2617}, {2649, 2652}, {2674, 2676}, {2693, 2699}, {2703, 2705}, {2707, 2728}, {2730, 2736}, {2738, 2739}, {2741, 2745}, {2821, 2828}, {2831, 2832}, {2835, 2856}, {2858, 2864}, {2866, 2867}, {2870, 2873}, {2908, 2909}, {2911, 2913}, {2949, 2954}, {2958, 2960}, {2962, 2965}, {2969, 2970}, {2974, 2975}, {2979, 2980}, {2984, 2986}, {2990, 2997}, {2999, 3001}, {3077, 3084}, {3086, 3088}, {3090, 3112}, {3114, 3123}, {3125, 3129}, {3168, 3169}, {3205, 3212}, {3214, 3216}, {3218, 3240}, {3242, 3251}, {3253, 3257}, {3296, 3297}, {3333, 3340}, {3342, 3344}, {3346, 3368}, {3370, 3385}, {3424, 3425}, {3585, 3630}, {3634, 3635}, {3648, 3653}, {3713, 3714}, {3719, 3720}, {3732, 3735}, {3737, 3743}, {3745, 3747}, {3754, 3755}, {3757, 3758}, {3762, 3763}, {3776, 3780}, {3904, 3911}, {3913, 3945}, {4256, 4293}, {4304, 4342}, {4354, 4355}, {4357, 4359}, {4363, 4364}, {4366, 4370}, {4436, 4437}, {4447, 4449}, {4461, 4462}, {4466, 4467}, {4526, 4527}, {4535, 4536}, {4540, 4546}, {7680, 7835}, {7840, 7929}, {7936, 7957}, {7960, 7965}, {7968, 8005}, {8008, 8013}, {8016, 8023}, {8031, 8061}, {8064, 8116}, {8118, 8124}, {8130, 8132}, {8134, 8140}, {8144, 8147}, {8150, 8155}, {8160, 8172}, {8178, 8180}, {8182, 8188}, {8490, 8491}, {8576, 8578}, {12353, 12436}, {12449, 12538}, {12549, 12588}, {44032, 55203}, {12321, 12329}, {19968, 40869}};
        int[] nArray5 = new int[]{902, 908, 986, 988, 990, 992, 1369, 1749, 2365, 2482, 2654, 2701, 2749, 2784, 2877, 2972, 3294, 3632, 3716, 3722, 3725, 3749, 3751, 3760, 3773, 4352, 4361, 4412, 4414, 4416, 4428, 4430, 4432, 4441, 4451, 4453, 4455, 4457, 4469, 4510, 4520, 4523, 4538, 4587, 4592, 4601, 8025, 8027, 8029, 8126, 8486, 8494, 12295};
        int[][] nArrayArray4 = new int[][]{{768, 837}, {864, 865}, {1155, 1158}, {1425, 1441}, {1443, 1465}, {1467, 1469}, {1473, 1474}, {1611, 1618}, {1750, 1756}, {1757, 1759}, {1760, 1764}, {1767, 1768}, {1770, 1773}, {2305, 2307}, {2366, 2380}, {2385, 2388}, {2402, 2403}, {2433, 2435}, {2496, 2500}, {2503, 2504}, {2507, 2509}, {2530, 2531}, {2624, 2626}, {2631, 2632}, {2635, 2637}, {2672, 2673}, {2689, 2691}, {2750, 2757}, {2759, 2761}, {2763, 2765}, {2817, 2819}, {2878, 2883}, {2887, 2888}, {2891, 2893}, {2902, 2903}, {2946, 2947}, {3006, 3010}, {3014, 3016}, {3018, 3021}, {3073, 3075}, {3134, 3140}, {3142, 3144}, {3146, 3149}, {3157, 3158}, {3202, 3203}, {3262, 3268}, {3270, 3272}, {3274, 3277}, {3285, 3286}, {3330, 3331}, {3390, 3395}, {3398, 3400}, {3402, 3405}, {3636, 3642}, {3655, 3662}, {3764, 3769}, {3771, 3772}, {3784, 3789}, {3864, 3865}, {3953, 3972}, {3974, 3979}, {3984, 3989}, {3993, 4013}, {4017, 4023}, {8400, 8412}, {12330, 12335}};
        int[] nArray6 = new int[]{1471, 1476, 1648, 2364, 2381, 2492, 2494, 2495, 2519, 2562, 2620, 2622, 2623, 2748, 2876, 3031, 3415, 3633, 3761, 3893, 3895, 3897, 3902, 3903, 3991, 4025, 8417, 12441, 12442};
        int[][] nArrayArray5 = new int[][]{{48, 57}, {1632, 1641}, {1776, 1785}, {2406, 2415}, {2534, 2543}, {2662, 2671}, {2790, 2799}, {2918, 2927}, {3047, 3055}, {3174, 3183}, {3302, 3311}, {3430, 3439}, {3664, 3673}, {3792, 3801}, {3872, 3881}};
        int[][] nArrayArray6 = new int[][]{{12337, 12341}, {12445, 12446}, {12540, 12542}};
        int[] nArray7 = new int[]{183, 720, 721, 903, 1600, 3654, 3782, 12293};
        int[] nArray8 = new int[]{60, 38, 93};
        for (n2 = 0; n2 < nArrayArray.length; ++n2) {
            n = nArrayArray[n2][0];
            while (n <= nArrayArray[n2][1]) {
                int n3 = n++;
                UNI_CHARS[n3] = (byte)(UNI_CHARS[n3] | 0x21);
            }
        }
        for (n2 = 0; n2 < nArray8.length; ++n2) {
            XMLChar.UNI_CHARS[nArray8[n2]] = (byte)(UNI_CHARS[nArray8[n2]] & 0xFFFFFFDF);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            UNI_CHARS[n4] = (byte)(UNI_CHARS[n4] | 2);
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            int n5 = nArray3[n2];
            UNI_CHARS[n5] = (byte)(UNI_CHARS[n5] | 0xCC);
        }
        for (n2 = 0; n2 < nArrayArray3.length; ++n2) {
            n = nArrayArray3[n2][0];
            while (n <= nArrayArray3[n2][1]) {
                int n6 = n++;
                UNI_CHARS[n6] = (byte)(UNI_CHARS[n6] | 0xCC);
            }
        }
        for (n2 = 0; n2 < nArray5.length; ++n2) {
            int n7 = nArray5[n2];
            UNI_CHARS[n7] = (byte)(UNI_CHARS[n7] | 0xCC);
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            int n8 = nArray2[n2];
            UNI_CHARS[n8] = (byte)(UNI_CHARS[n8] | 0x88);
        }
        for (n2 = 0; n2 < nArrayArray5.length; ++n2) {
            n = nArrayArray5[n2][0];
            while (n <= nArrayArray5[n2][1]) {
                int n9 = n++;
                UNI_CHARS[n9] = (byte)(UNI_CHARS[n9] | 0x88);
            }
        }
        for (n2 = 0; n2 < nArrayArray4.length; ++n2) {
            n = nArrayArray4[n2][0];
            while (n <= nArrayArray4[n2][1]) {
                int n10 = n++;
                UNI_CHARS[n10] = (byte)(UNI_CHARS[n10] | 0x88);
            }
        }
        for (n2 = 0; n2 < nArray6.length; ++n2) {
            int n11 = nArray6[n2];
            UNI_CHARS[n11] = (byte)(UNI_CHARS[n11] | 0x88);
        }
        for (n2 = 0; n2 < nArrayArray6.length; ++n2) {
            n = nArrayArray6[n2][0];
            while (n <= nArrayArray6[n2][1]) {
                int n12 = n++;
                UNI_CHARS[n12] = (byte)(UNI_CHARS[n12] | 0x88);
            }
        }
        for (n2 = 0; n2 < nArray7.length; ++n2) {
            int n13 = nArray7[n2];
            UNI_CHARS[n13] = (byte)(UNI_CHARS[n13] | 0x88);
        }
        UNI_CHARS[58] = (byte)(UNI_CHARS[58] & 0xFFFFFF3F);
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            int n14 = nArray4[n2];
            UNI_CHARS[n14] = (byte)(UNI_CHARS[n14] | 0x10);
        }
        for (n2 = 0; n2 < nArrayArray2.length; ++n2) {
            n = nArrayArray2[n2][0];
            while (n <= nArrayArray2[n2][1]) {
                int n15 = n++;
                UNI_CHARS[n15] = (byte)(UNI_CHARS[n15] | 0x10);
            }
        }
    }
}

