/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.setting.dialect;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.ReUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.URLUtil;
import com.xiaoleilu.hutool.exceptions.SettingException;
import com.xiaoleilu.hutool.setting.AbsSetting;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class GroupSetting
extends AbsSetting {
    private static Logger log = Log.get();
    final Map<String, String> map = new HashMap<String, String>();
    public static final String DEFAULT_CHARSET = "utf8";
    public static final String DEFAULT_DELIMITER = ",";
    private static final String COMMENT_FLAG_PRE = "#";
    private static final String ASSIGN_FLAG = "=";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private String reg_var = "\\$\\{(.*?)\\}";
    private Charset charset;
    private boolean isUseVariable;
    private URL settingUrl;
    private LinkedList<String> groups = new LinkedList();

    public GroupSetting(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public GroupSetting(String pathBaseClassLoader, String charset, boolean isUseVariable) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = URLUtil.getURL(pathBaseClassLoader)) == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", pathBaseClassLoader));
        }
        this.init(url, charset, isUseVariable);
    }

    public GroupSetting(File configFile, String charset, boolean isUseVariable) {
        if (configFile == null) {
            throw new RuntimeException("Null Setting file!");
        }
        URL url = URLUtil.getURL(configFile);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", configFile.getAbsolutePath()));
        }
        this.init(url, charset, isUseVariable);
    }

    public GroupSetting(String path, Class<?> clazz, String charset, boolean isUseVariable) {
        URL url = URLUtil.getURL(path, clazz);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", path));
        }
        this.init(url, charset, isUseVariable);
    }

    public GroupSetting(URL url, String charset, boolean isUseVariable) {
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init(url, charset, isUseVariable);
    }

    public GroupSetting(String pathBaseClassLoader) {
        this(pathBaseClassLoader, DEFAULT_CHARSET, false);
    }

    public boolean init(URL settingUrl, String charset, boolean isUseVariable) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url or charset define!");
        }
        try {
            this.charset = Charset.forName(charset);
        }
        catch (Exception e) {
            log.warn("User custom charset [{}] parse error, use default charset: [{}]", (Object)charset, (Object)DEFAULT_CHARSET);
            this.charset = Charset.forName(DEFAULT_CHARSET);
        }
        this.isUseVariable = isUseVariable;
        this.settingUrl = settingUrl;
        return this.load(settingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean load(URL settingUrl) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", (Object)settingUrl.getPath());
        InputStream settingStream = null;
        try {
            settingStream = settingUrl.openStream();
            this.load(settingStream, this.isUseVariable);
        }
        catch (IOException e) {
            log.error("Load setting error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.close(settingStream);
        }
        return true;
    }

    public void reload() {
        this.load(this.settingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream, boolean isUseVariable) throws IOException {
        this.map.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(settingStream, this.charset));
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    group = line.substring(1, line.length() - 1).trim();
                    this.groups.add(group);
                    continue;
                }
                String[] keyValue = line.split(ASSIGN_FLAG, 2);
                if (keyValue.length < 2) continue;
                String key = keyValue[0].trim();
                if (!StrUtil.isBlank(group)) {
                    key = group + "." + key;
                }
                String value = keyValue[1].trim();
                if (isUseVariable) {
                    value = this.replaceVar(value);
                }
                this.map.put(key, value);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(reader);
            throw throwable;
        }
        FileUtil.close(reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    public String getSettingPath() {
        return this.settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public String getStr(String key) {
        return this.map.get(key);
    }

    public String getByGroup(String key, String group) {
        String keyWithGroup = key;
        if (!StrUtil.isBlank(group)) {
            keyWithGroup = group + "." + keyWithGroup;
        }
        return this.getStr(keyWithGroup);
    }

    public void setSetting(String key, Object value) {
        this.map.put(key, value.toString());
    }

    public void store(String absolutePath) {
        try {
            FileUtil.touch(absolutePath);
            OutputStream out = FileUtil.getOutputStream(absolutePath);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, this.charset));
            Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                writer.write(entry.getKey() + ASSIGN_FLAG + entry.getValue());
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(StrUtil.format("Can not find file [{}]!", absolutePath), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Store Setting error!", e);
        }
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path, clazz));
    }

    public void toObject(String group, Object object) throws SettingException {
        try {
            Method[] methods;
            for (Method method : methods = object.getClass().getMethods()) {
                Class<?>[] parameterTypes;
                String field;
                String value;
                String methodName = method.getName();
                if (!methodName.startsWith("set") || (value = this.getByGroup(field = StrUtil.getGeneralField(methodName), group)) == null || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                Object castedValue = Conver.parse(parameterTypes[0], value);
                method.invoke(object, castedValue);
                log.debug("Parse setting to object field [{}={}]", (Object)field, (Object)value);
            }
        }
        catch (Exception e) {
            throw new SettingException("Parse setting to object error!", e);
        }
    }

    public void toObject(Object object) throws SettingException {
        this.toObject(null, object);
    }

    public LinkedList<String> getGroups() {
        return this.groups;
    }

    private String replaceVar(String value) {
        Set vars = ReUtil.findAll(this.reg_var, value, 0, new HashSet());
        for (String var : vars) {
            String varValue = this.map.get(ReUtil.get(this.reg_var, var, 1));
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

